<?php

namespace App\Helper;

use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ApiHelper
{

    private static $BASE_URL = "http://192.168.9.121:8000/";
    private static $CREATE_VM = "create-streaming-server";
    private static $GET_STREAM_METADATA = 'get_stream_metadata';
    private static $GET_CREATE_VM = "vm-status";
    private static $RESTART_STREAMING_SERVER = "restart_streaming_server";
    private static $GENERATE_VIDOE = "generate_video";
    private static $EXTACT_FRAME_FACES = "extract_frame_faces";

    public static $ENCRYPT_KEY = "mPQKWfKQ4nvMlKpAA4SFIcIgInnXMpVI";
    public static $BARREAR_TOKEN = "eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6ImFiZCBzaWFsa290IiwiaWF0IjoyMTIxMTIyfQ.QOBwsC-49jzVPFa6CWevOC7jHN2vi056xL0zyXCwk6I";


    public static function create_stream_vm($params, $enc, $vi)
    {
        $client = new Client();
        return $client->post(
            ApiHelper::$BASE_URL . ApiHelper::$CREATE_VM,
            [

                'json' => $params,
                'headers' => [
                    'Authorization' => 'Bearer ' . ApiHelper::$BARREAR_TOKEN,
                    'LG_TOKEN' => $enc,
                    'SM_TOKEN' => $vi,
                ]
            ]
        );
        //return $response->getBody()->getContents();
    }

    public static function get_stream_vm($params)
    {
        $client = new Client();
        return $client->post(ApiHelper::$BASE_URL . ApiHelper::$GET_CREATE_VM, ['json' => $params]);

        //return $response->getBody()->getContents();
    }

    public static function restart_streamming_server($params)
    {
        $error = false;
        $client = new Client();
        $response = $client->post(ApiHelper::$BASE_URL . ApiHelper::$RESTART_STREAMING_SERVER, ['json' => $params]);
        $statusCode = $response->getStatusCode();


        if ($statusCode == 200) {
            //echo   $response; die();
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);

            if (isset($data['error'])) {

                if ($data['error'] == true) {

                    $error = true;
                } else {
                    $error = false;
                    //  session()->flash('success',$data['message']);
                }
            } else {
                $error = true;
            }
        } else {
            $error = true;
        }
    }

    public static function verify_stream($params)
    {
        $client = new Client();
        $response = $client->post(ApiHelper::$BASE_URL . ApiHelper::$GET_STREAM_METADATA, ['json' => $params]);
        $statusCode = $response->getStatusCode();
        if ($statusCode == 200) {
            $body = $response->getBody()->getContents();
            return json_decode($body, true);
        }


        return false;
    }

    public static function generate_frame_video($params)
    {

        $client = new Client();
        $response = $client->post(
            ApiHelper::$BASE_URL . ApiHelper::$GENERATE_VIDOE,
            [

                'json' => [
                    'video_folder_path' => $params
                ]
            ]
        );

        $statusCode = $response->getStatusCode();
        // \Log::info('response:' . $response->getBody());

        if ($statusCode == 200) {
            $body = $response->getBody()->getContents();
            return json_decode($body, true);
        }

        return false;
    }

    public static function extact_frame_faces($params)
    {
        $client = new Client();
        $response = $client->post(
            ApiHelper::$BASE_URL . ApiHelper::$EXTACT_FRAME_FACES,
            [
                'headers' => [
                    'Accept' => 'application/json',
                    'Content-Type' => 'application/json',
                ],
                'json' => [
                    'photo_frame_base64' => $params['photo_frame_base64'] // Ensure $params is a base64-encoded string
                ]
            ]
        );

        $statusCode = $response->getStatusCode();
        // \Log::info('response:' . $response->getBody());

        if ($statusCode == 200) {
            $body = $response->getBody()->getContents();
            return json_decode($body, true);
        } else {
            \Log::error('Error: ' . $response->getBody());
            return null;
        }

    }
}
