<?php

namespace App\Helper;

use MongoDB\Client as MongoDBClient;
use MongoDB\BSON\UTCDateTime;


class MongoHelper
{

    protected $mongoDB;

    public function __construct(MongoDBClient $mongoDB)
    {
        $this->mongoDB = $mongoDB;
    }

    public  function findCamera($id, $user_id)
    {

        $collection = $this->mongoDB->dataprocess->cameras;

        $result = $collection->find(
            [
                '_id' => new \MongoDB\BSON\ObjectID($id),
                'user_id' => $user_id
            ]
        );

       
        $result = $result->toArray();
        return  $result;
    }

    public function insertDataToCollection($dataToInsert,$collection){
        
      

        $currentDateTime = date('Y-m-d H:i:s');

        // Convert the formatted date to MongoDB BSON DateTime
        $dateTime = new UTCDateTime(strtotime($currentDateTime) * 1000);

        // Get the collection instance
        // Insert the new document into the collection
        $insertResult = $collection->insertOne($dataToInsert);

        // Check if the insertion was successful
        if ($insertResult->getInsertedCount() > 0) {
            // Get the ID of the inserted document
           return $insertResult->getInsertedId();
           
        } else {
            return null;
        }
    }
    // done
}
