<?php

namespace App\Http\Controllers;

use App\Helper\ApiHelper;
use App\Helper\Encryption;
use App\Helper\HelperData;
use App\Helper\MongoHelper;
use App\Rules\Base64Validation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use MongoDB\Client as MongoDBClient;
use MongoDB\BSON\UTCDateTime;
use MongoDB\BSON\ObjectId;
use Carbon\Carbon;


class AddDataController extends Controller
{

    protected $mongoDB;
    protected $mongoHelper;

    public function __construct(MongoDBClient $mongoDB)
    {
        $this->middleware('auth');
        $this->mongoDB = $mongoDB;
        $this->mongoHelper = new MongoHelper($this->mongoDB);
    }


    public function edit_origin($id)
    {


        $data = null;
        $collections = $this->mongoDB->dataprocess->regions;
        $result = $collections->find(['_id' => new \MongoDB\BSON\ObjectID($id)]);
        foreach ($result as $list) {
            $data = $list;
        }
        return view("add.edit_region", compact('data'));
    }


    /** Get All Regions */

    public function all_regions_views()
    {

        $collections = $this->mongoDB->dataprocess->regions;
        $result = $collections->find([
            'uuid' => Auth::user()->uuid
        ], [
            'sort' => ['_id' => -1]
        ]);

        return view("add.regions_all_list", compact('result'));
    }

    public function add_region_view()
    {
        return view("add.add_region");
    }


    public function update_region(Request $request)
    {
        if (!$request->region || !$request->id) {
            session()->flash("error", "Missing data");
            return back();
        }


        $collection = $this->mongoDB->dataprocess->regions;

        // Convert the formatted date to MongoDB BSON DateTime

        // Get the collection instance

        $updateData = [
            '$set' => [
                'region' => $request->region,
                'status' => ($request->status) ? 1 : 0,
            ]
            // Add other fields and their values
        ];

        // Insert the new document into the collection
        $updateResult = $collection->updateOne(
            ['_id' => new \MongoDB\BSON\ObjectID($request->id)],
            $updateData
        );

        // Check if the insertion was successful
        if ($updateResult->getModifiedCount() > 0) {
            // Get the ID of the inserted document
            if ($updateResult->getModifiedCount() > 0) {
                session()->flash("success", "Region updated successfully");
            } else {
                session()->flash("error", "No modifications made");
            }
        }

        return redirect(route('all.rigions.lists'));
    }

    public function add_new_region(Request $request)
    {
        if (!$request->region) {
            session()->flash("error", "Missing data");
            return back();
        }



        $collection = $this->mongoDB->dataprocess->regions;
        $existingRegion = $collection->findOne(['region' => $request->region]);

        if ($existingRegion) {
            session()->flash("error", "Region already exists");
            return back();
        }

        $currentDateTime = date('Y-m-d H:i:s');

        // Convert the formatted date to MongoDB BSON DateTime
        $dateTime = new UTCDateTime(strtotime($currentDateTime) * 1000);

        // Get the collection instance

        $dataToInsert = [
            'region' => $request->region,
            'status' => ($request->status) ? 1 : 0,
            'created_at' => $dateTime,
            'uuid' => Auth::user()->uuid
        ];

        // Insert the new document into the collection
        $insertResult = $collection->insertOne($dataToInsert);

        // Check if the insertion was successful
        if ($insertResult->getInsertedCount() > 0) {
            // Get the ID of the inserted document
            $insertedId = $insertResult->getInsertedId();
            session()->flash("success", "Region added successfully");
        } else {
            session()->flash("error", "Sorry try again");
        }

        return redirect(route('all.rigions.lists'));
    }

    /**================= Cameras Functions  ============= */

    public function view_all_cameras($region)
    {

        $collection = $this->mongoDB->dataprocess->cameras;

        $pipeline = [
            [
                '$match' => [
                    'user_id' => auth()->user()->uuid,
                    'region_id' => new \MongoDB\BSON\ObjectID($region)
                ]
            ],
            [
                '$lookup' => [
                    'from' => 'regions',
                    'localField' => 'region_id',
                    'foreignField' => '_id',
                    'as' => 'region'
                ]
            ],
            ['$unwind' => '$region'],
            [
                '$addFields' => [
                    'region_name' => '$region.name',
                    'region_description' => '$region.description'
                ]
            ],
            ['$sort' => ['_id' => -1]]
        ];

        $cameras = $collection->aggregate($pipeline)->toArray();
        return view("add.cameras_list", compact('cameras', 'region'));
    }

    public function view_only_cameras()
    {
        try {
            $collection = $this->mongoDB->dataprocess->cameras;

            $pipeline = [
                [
                    '$match' => [
                        'user_id' => auth()->user()->uuid,
                        'region_id' => ['$exists' => true, '$ne' => null]
                    ]
                ],
                [
                    '$lookup' => [
                        'from' => 'regions',
                        'let' => ['region_id' => ['$toObjectId' => '$region_id']],
                        'pipeline' => [
                            ['$match' => ['$expr' => ['$eq' => ['$_id', '$$region_id']]]]
                        ],
                        'as' => 'region'
                    ]
                ],
                ['$unwind' => '$region'],
                [
                    '$addFields' => [
                        'region_name' => '$region.name',
                        'region_description' => '$region.description'
                    ]
                ],
                ['$sort' => ['_id' => -1]]
            ];

            $cameras = $collection->aggregate($pipeline)->toArray();
            // dd($cameras);

        } catch (Exception $e) {
            dd("An error occurred: " . $e->getMessage());
        }


        return view("add.cameras_list", compact('cameras'));
    }


    public function add_camera_view($id)
    {
        $regions = $this->mongoDB->dataprocess->regions;
        $regions = $regions->find(['_id' => new \MongoDB\BSON\ObjectID($id)]);
        $regions = $regions->toArray();

        if (count($regions) > 0) {
            return view("add.add_camera", compact('id', 'regions'));
        } else {
            session()->flash('error', "Invalid region data");
            return back();
        }
    }


    public function add_streamWithCamera($region_id = "")
    {
        $regions = $this->mongoDB->dataprocess->regions;
        // $allRegions = $regions->find()->toArray();
        $allRegions = $regions->find(['uuid' => auth()->user()->uuid])->toArray();

        return view("add.add_camera_and_region", compact('allRegions', 'region_id'));
    }


    public function save_streamWithCamera(request $request)
    {
        // dd($request);


        $request->validate([
            // 'region' => 'required|string',
            'camera' => 'required|string',
            'url' => 'required|url',
        ]);

        //  ~~~~~ add region ~~~~~

        if ($request->has('region') && $request->region != "") {

            $collection = $this->mongoDB->dataprocess->regions;
            $existingRegion = $collection->findOne(['region' => $request->region]);

            if ($existingRegion) {
                session()->flash("error", "Region already exists");
                return back();
            }

            $currentDateTime = date('Y-m-d H:i:s');

            // Convert the formatted date to MongoDB BSON DateTime
            $dateTime = new UTCDateTime(strtotime($currentDateTime) * 1000);

            // Get the collection instance

            $dataToInsert = [
                'region' => $request->region,
                'status' => ($request->status) ? 1 : 0,
                'created_at' => $dateTime,
                'uuid' => Auth::user()->uuid
            ];

            // Insert the new document into the collection
            $insertResult = $collection->insertOne($dataToInsert);
        }

        // ~~~~~ add camera ~~~~~~
        $region_id = $request->region_id;

        if (isset($insertResult) && $insertResult->getInsertedCount() > 0) {
            $region_id = $insertResult->getInsertedId();
        }

        $collection = $this->mongoDB->dataprocess->cameras;

        $currentDateTime = date('Y-m-d H:i:s');

        // Convert the formatted date to MongoDB BSON DateTime
        $dateTime = new UTCDateTime(strtotime($currentDateTime) * 1000);


        $is_allow_face_detection = 0;
        // is_allow_emotion_detection
        $is_allow_face_detection = $request->has('is_allow_face_detection') ? 1 : 0;

        $is_allow_emotion_detection = $request->has('is_allow_emotion_detection') ? 1 : 0;
        $is_allow_attendance = $request->has('is_allow_attendance') ? 1 : 0;
        $is_allow_count_attendees = $request->has('is_allow_count_attendees') ? 1 : 0;

        // if($request->has('is_allow_face_detection')){
        //     $is_allow_face_detection = 1;
        // }

        $dataToInsert = [
            'cameraname' => $request->camera,
            'stream_url' => $request->url,
            'status' => ($request->status) ? 1 : 0,
            'region_id' => new \MongoDB\BSON\ObjectID($region_id),
            'user_id' => auth()->user()->uuid,
            'video_type' => $request->video_type,
            'is_virtial_wall' => 1,
            'is_allow_face_detection' => $is_allow_face_detection,
            'is_allow_emotion_detection' => $is_allow_emotion_detection,
            'is_allow_attendance' => $is_allow_attendance,
            'is_allow_count_attendees' => $is_allow_count_attendees,
            'created_at' => $dateTime,

        ];



        // Insert the new document into the collection
        $insertResult = $collection->insertOne($dataToInsert);

        // Check if the insertion was successful
        if ($insertResult->getInsertedCount() > 0) {
            // Get the ID of the inserted document
            $insertedId = $insertResult->getInsertedId();
            $lastid = json_encode($insertedId, false);
            $data = json_decode($lastid, true); // Decode the JSON string
            // Access the value associated with the key '$oid'
            $oidValue = $data['$oid'];
            // Now $oidValue contains the ObjectId value
            $stream_name = preg_replace("/[^a-zA-Z0-9]/", "", $request->camera);

            $params = [
                'stream_name' => $stream_name,
                'stream_url' => $request->url,
                'request_id' => "11111",
                'camera_id' => $oidValue,
                'region_id' => (string) $region_id,
                'access_token' => '123456',
            ];



            // Encrypt user  information
            $enc = Encryption::encrypt(Auth()->user()->uuid);

            $encryptedData = $enc['encryptedData'];
            $iv = $enc['iv'];

            $params['encrypt'] = $enc['encryptedData'];
            $params['iv'] = $enc['iv'];
            // echo json_encode($params); die();
            // Create VM API
            //dd($params);
            $response = ApiHelper::create_stream_vm($params, $encryptedData, $iv);

            $statusCode = $response->getStatusCode();

            if ($statusCode == 200) {
                $body = $response->getBody()->getContents();
                $data = json_decode($body, true);

                if (isset($data['error'])) {
                    if ($data['error'] == true) {
                        session()->flash('error', $data['message']);
                    } else {


                        //==========================
                        // Insert stream settings
                        //==========================

                        $collection_camera_stream = $this->mongoDB->dataprocess->camera_stream_settings;
                        $data = [
                            'user_id' => auth()->user()->uuid,
                            'camera_id' => new \MongoDB\BSON\ObjectID($oidValue),
                            'extract_frame_time' => 10
                        ];
                        $result = $this->mongoHelper->insertDataToCollection($data, $collection_camera_stream);

                        session()->flash("success", "Stream created successfully");
                        //  session()->flash('success',$data['message']);
                    }
                } else {
                    session()->flash('error', 'Invalid data set to create virtial machine');
                }
            } else {
                session()->flash('error', 'Invalid data set to create virtial machine');
            }
        } else {
            session()->flash("error", "Sorry try again");
        }
        // dd($request->region);
        return redirect(route('all.cameras.lists', $region_id));
    }

    public function add_camera2_view()
    {
        $regions = $this->mongoDB->dataprocess->regions;
        $regions = $regions->find([]);
        return view("add.add_camera_with_rigion", compact('regions'));
    }

    /**
     * Add new camera
     */

    public function add_new_camera(Request $request)
    {

        $request->validate([
            'region' => 'required|string',
            'camera' => 'required|string',
            'url' => 'required|url',
        ]);

        // $url = str_replace(array("http://", "https://"), "", $request->url);

        // $isStream = HelperData::isStreamGood($url);


        // if ($isStream != 200) {
        //     return redirect()->back()->withInput()->with('error', 'Invalid URL format');
        // }

        $collection = $this->mongoDB->dataprocess->cameras;

        $currentDateTime = date('Y-m-d H:i:s');

        // Convert the formatted date to MongoDB BSON DateTime
        $dateTime = new UTCDateTime(strtotime($currentDateTime) * 1000);

        // Get the collection instance

        $dataToInsert = [
            'cameraname' => $request->camera,
            'stream_url' => $request->url,
            'status' => ($request->status) ? 1 : 0,
            'region_id' => new \MongoDB\BSON\ObjectID($request->region),
            'created_at' => $dateTime,
            'user_id' => auth()->user()->uuid,
            'is_virtial_wall' => 1,
            // Add other fields and their values
        ];

        // Insert the new document into the collection
        $insertResult = $collection->insertOne($dataToInsert);

        // Check if the insertion was successful
        if ($insertResult->getInsertedCount() > 0) {
            // Get the ID of the inserted document
            $insertedId = $insertResult->getInsertedId();
            $lastid = json_encode($insertedId, false);
            $data = json_decode($lastid, true); // Decode the JSON string
            // Access the value associated with the key '$oid'
            $oidValue = $data['$oid'];
            // Now $oidValue contains the ObjectId value
            $stream_name = preg_replace("/[^a-zA-Z0-9]/", "", $request->camera);

            $params = [
                'stream_name' => $stream_name,
                'stream_url' => $request->url,
                'request_id' => "11111",
                'camera_id' => $oidValue,
                'region_id' => $request->region,
                'access_token' => '123456',
            ];



            // Encrypt user  information
            $enc = Encryption::encrypt(Auth()->user()->uuid);

            $encryptedData = $enc['encryptedData'];
            $iv = $enc['iv'];

            $params['encrypt'] = $enc['encryptedData'];
            $params['iv'] = $enc['iv'];
            // echo json_encode($params); die();
            // Create VM API
            $response = ApiHelper::create_stream_vm($params, $encryptedData, $iv);

            $statusCode = $response->getStatusCode();

            if ($statusCode == 200) {
                $body = $response->getBody()->getContents();
                $data = json_decode($body, true);

                if (isset($data['error'])) {
                    if ($data['error'] == true) {
                        session()->flash('error', $data['message']);
                    } else {


                        //==========================
                        // Insert stream settings
                        //==========================

                        $collection_camera_stream = $this->mongoDB->dataprocess->camera_stream_settings;
                        $data = [
                            'user_id' => auth()->user()->uuid,
                            'camera_id' => new \MongoDB\BSON\ObjectID($oidValue),
                            'extract_frame_time' => 10
                        ];
                        $result = $this->mongoHelper->insertDataToCollection($data, $collection_camera_stream);

                        session()->flash("success", "Stream created successfully");
                        //  session()->flash('success',$data['message']);
                    }
                } else {
                    session()->flash('error', 'Invalid data set to create virtial machine');
                }
            } else {
                session()->flash('error', 'Invalid data set to create virtial machine');
            }
        } else {
            session()->flash("error", "Sorry try again");
        }

        return redirect(route('all.cameras.lists', $request->region));
    }

    public function findCamera($id)
    {

        $collection = $this->mongoDB->dataprocess->cameras;

        $result = $collection->find(
            [
                '_id' => new \MongoDB\BSON\ObjectID($id)
            ]
        );
        $data = null;
        foreach ($result as $rs) {
            $data = $rs;
        }

        return view("add.edit_camera", compact("data"));
    }


    /*
      Update Camera
    */

    public function updateCamera(Request $request)
    {
        // echo json_encode($request->all());
        // die();


        $request->validate([
            'region' => 'required|string',
            'camera' => 'required|string',
            'url' => 'required|url',
            'id' => 'required|string',
        ]);

        $collection = $this->mongoDB->dataprocess->cameras;

        // $isStream = HelperData::isStreamGood($request->url);

        // if ($isStream == 505) {
        //     session()->flash("error", "Invalid URL format");
        // }

        // if ($isStream != 200) {
        //     return redirect(route('all.cameras.lists'));
        // }

        // Convert the formatted date to MongoDB BSON DateTime

        // Get the collection instance

        $updateData = [
            '$set' => [
                'cameraname' => $request->camera,
                'stream_url' => $request->url,
                'status' => ($request->status) ? 1 : 0,
            ]
            // Add other fields and their values
        ];

        // Insert the new document into the collection
        $updateResult = $collection->updateOne(

            [
                '_id' => new \MongoDB\BSON\ObjectID($request->id),
                'user_id' => auth()->user()->uuid
            ],

            $updateData
        );

        // dd($updateResult);


        // Check if the insertion was successful
        if ($updateResult->getModifiedCount() > 0) {
            // Get the ID of the inserted document
            session()->flash("success", "Camera updated successfully");
        } else {
            session()->flash("error", "Sorry try again");
        }

        return redirect(route('all.cameras.lists', $request->region));
    }


    /*
      Delete Camera
    */

    public function deleteCamera($id)
    {
        $collection = $this->mongoDB->dataprocess->cameras;

        // Delete a single document by its _id
        $deleteResult = $collection->deleteOne([
            '_id' => new \MongoDB\BSON\ObjectID($id),
            'user_id' => auth()->user()->uuid
        ]);

        // Check if the deletion operation was successful
        // if ($deleteResult->getDeletedCount() > 0) {

        // } else {

        // }
        session()->flash("success", "Camera deleted successfully");
        return back();
    }

    public function camera_statistics($camera_id)
    {
        $collection = $this->mongoDB->dataprocess->steaming_info;
        $result = $collection->findOne([
            'camera_id' => new \MongoDB\BSON\ObjectID($camera_id),
            // 'user_id' => auth()->user()->uuid
        ]);

        return view('camera.statistics.index', compact('result'));
    }

    public function monitor_stream($camera_id)
    {

        $collection = $this->mongoDB->dataprocess->users_streams_vm;

        $result = $collection->findOne([
            'camera_id' => new \MongoDB\BSON\ObjectID($camera_id),
            //'user_id' => auth()->user()->uuid
        ]);

        if ($result) {

            $collection = $this->mongoDB->dataprocess->cameras;
            $collection_alarm_counts = $this->mongoDB->dataprocess->stream_alarm_counts;
            $collection_custom_alarm = $this->mongoDB->dataprocess->camera_alarms_settings;


            $custom_alarm = $collection_custom_alarm->findOne([
                'camera_id' => new \MongoDB\BSON\ObjectID($camera_id),
            ]);

            $stream = $collection->findOne([
                '_id' => new \MongoDB\BSON\ObjectID($camera_id),
                // 'user_id' => auth()->user()->uuid
            ]);

            $alarm_collections = $collection_alarm_counts->findOne([
                'camera_id' => new \MongoDB\BSON\ObjectID($camera_id),
                // 'user_id' => auth()->user()->uuid
            ]);

            $collection = $this->mongoDB->dataprocess->steaming_info;
            $steaming_info = $collection->findOne([
                'camera_id' => new \MongoDB\BSON\ObjectID($camera_id),
                // 'user_id' => auth()->user()->uuid
            ]);

            $cameraname = $stream['cameraname'];

            $collection = $this->mongoDB->dataprocess->regions;
            $region = $collection->findOne([
                '_id' => new \MongoDB\BSON\ObjectID($stream['region_id']), // Corrected to match _id with region_id
            ]);
            $region_name = $region['region'];

            // Document found, return the _id
            $container = (string) $result['container_id']; // Convert BSON ObjectID to string

            $threshold_values = [
                '250',
                '600',
                '1000',
                '2000',
                '4000',
                '6000',
                '10000'
            ];

            $is_custom_threshold = $custom_alarm !== null && in_array($custom_alarm->threshold_value, $threshold_values) ? 0 : 1;


            // dd($is_custom_threshold);
            return view("streams.view_stream", compact('result', 'container', 'cameraname', 'steaming_info', 'alarm_collections', 'region_name', 'custom_alarm', 'is_custom_threshold'));
        } else {
            // Document not found, handle the error
            // For example, return a message or throw an exception
            session()->flash('error', 'Stream not active yet');
            return back();
        }
        session()->flash('error', 'Stream not active yet');
        return back();
    }

    public function get_container_info(Request $request)
    {

        $request->validate([
            'container' => "required|string"
        ]);

        $response = ApiHelper::get_stream_vm([
            "request_id" => "11111",
            "container_id" => $request->container,
            "access_token" => "123456"
        ]);

        $statusCode = $response->getStatusCode();

        if ($statusCode == 200) {
            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);

            if (isset($data['error'])) {

                if ($data['error'] == true) {

                    return response()->json([
                        'error' => true,
                        'error_code' => 1001,
                        'data' => "Sorry invalid data"
                    ]);
                } else {
                    return response()->json([
                        'error' => false,
                        'data' => $data['data']['Status']
                    ]);
                    //  session()->flash('success',$data['message']);
                }
            } else {
                return response()->json([
                    'error' => true,
                    'error_code' => 1002,
                    'data' => "Sorry invalid data"
                ]);
            }
        } else {
            return response()->json([
                'error' => true,
                'error_code' => 1003,
                'data' => "Sorry invalid data"
            ]);
        }
    }

    public function camera_stream_setting($camera_id)
    {
        $collection = $this->mongoDB->dataprocess->cameras;
        $result = $collection->findOne([
            '_id' => new \MongoDB\BSON\ObjectID($camera_id),
            // 'user_id' => auth()->user()->uuid
        ]);

        if (!$result) {
            session()->flash("error", "Sorry invalid camera");
            return back();
        }

        $settings = $this->mongoDB->dataprocess->camera_stream_settings;
        $settings = $settings->findOne([
            'camera_id' => new \MongoDB\BSON\ObjectID($camera_id),
            // 'user_id' => auth()->user()->uuid
        ]);


        return view("camera.settings.stream_setting", compact('settings', 'camera_id'));
    }

    public function store_camera_stream_setting(Request $request)
    {

        $request->validate([
            'setting' => 'required|string',
            'camera' => 'required|string',
            'extract_frame_time' => 'required|numeric|min:0',
        ]);

        $collection = $this->mongoDB->dataprocess->cameras;

        $result = $collection->findOne([
            '_id' => new \MongoDB\BSON\ObjectID($request->camera),
            // 'user_id' => auth()->user()->uuid
        ]);

        if (!$result) {
            session()->flash("error", "Sorry invalid camera");
            return back();
        }

        $updateData = [
            '$set' => [
                'extract_frame_time' => $request->extract_frame_time,
            ]
            // Add other fields and their values
        ];

        $settings = $this->mongoDB->dataprocess->camera_stream_settings;

        // Insert the new document into the collection
        $updateResult = $settings->updateOne(
            [
                '_id' => new \MongoDB\BSON\ObjectID($request->setting),
                'camera_id' => new \MongoDB\BSON\ObjectID($request->camera),
            ],
            $updateData
        );

        // Check if the insertion was successful
        if ($updateResult->getModifiedCount() > 0) {
            // Get the ID of the inserted document
            if ($updateResult->getModifiedCount() > 0) {


                $collection_vm = $this->mongoDB->dataprocess->users_streams_vm;

                $result = $collection_vm->findOne([
                    'camera_id' => new \MongoDB\BSON\ObjectID($request->camera),
                    'user_id' => auth()->user()->uuid
                ]);


                $response = ApiHelper::restart_streamming_server([
                    "request_id" => "11111",
                    "container_id" => $result['container_id'],
                    "access_token" => "123456",
                    "camera_id" => $request->camera,
                    "user_id" => Auth::user()->uuid
                ]);

                if ($response) {
                    session()->flash("success", "Stream settings updated successfully");
                } else {
                    session()->flash("error", "Sorry try again");
                }
            } else {
                session()->flash("error", "No modifications made 1001");
            }
        } else {
            session()->flash("error", "No modifications made 1002");
        }
        return back();
    }

    public function add_faces($camera_id)
    {
        $collection = $this->mongoDB->dataprocess->cameras;
        $camera = $collection->findOne(['_id' => new \MongoDB\BSON\ObjectID($camera_id)]);

        $collection = $this->mongoDB->dataprocess->regions;
        $region = $collection->findOne(['_id' => new \MongoDB\BSON\ObjectID($camera['region_id'])]);



        return view('add.add_faces', compact('camera_id', 'camera', 'region'));
    }

    public function save_faces(request $request)
    {

        // echo json_encode($request->all());
        // die();
        // dd($request->all());


        if (!$request->hasFile('face_image') && empty($request->face_image_base64) && empty($request->face_image_base64_capture)) {
            return redirect()->back()->with('error', 'Please upload an image.');
        }

        $data = [
            'attendee_name' => 'required|string',
            'camera_id' => 'required|string',
        ];

        if ($request->image_source == "camera") {
            $data['face_image_base64'] = 'required|string';
        } else if ($request->image_source == "direct") {
            $data['face_image'] = 'required|image|mimes:jpeg,png,jpg,gif|max:2048';
        }

        // apply validation
        $request->validate($data);

        if ($request->hasFile('face_image')) {
            $file = $request->file('face_image');
            $base64 = base64_encode(file_get_contents($file->getRealPath()));
        } elseif (!empty($request->face_image_base64_capture)) {
            $base64 = $request->face_image_base64_capture;
            // $base64 = str_replace('data:image/png;base64,', '', $base64);
        } else {
            $base64 = $request->face_image_base64;
            $base64 = str_replace('data:image/png;base64,', '', $base64);
        }

        //if ($request->hasFile('face_image')) {


        $mongoHelper = app(MongoHelper::class);
        $getCamera = $mongoHelper->findCamera($request->camera_id, Auth::user()->uuid);

        $cameraData = $getCamera[0];

        $cameraArray = $cameraData->getArrayCopy();

        if (isset($cameraArray['region_id'])) {
            $region_id = $cameraArray['region_id'];

            $currentUtcDateTime = new UTCDateTime(); // Current UTC datetime


            $uuid = Auth::user()->uuid;

            $collection = $this->mongoDB->dataprocess->face_for_search;
            // $lastRecord = $collection->findOne(['user_id' => $uuid], ['sort' => ['_id' => -1]]);

            // $local_id = 1;

            // if($lastRecord){
            //     if(isset($lastRecord['local_id'])){
            //         $local_id = $lastRecord['local_id'] + 1;
            //     }
            // }

            $time = substr((string) time(), -4);

            $local_id = Auth::user()->name . '_' . Auth::user()->id . $time;

            // Remove spaces from the name
            $local_id = str_replace(' ', '', $local_id);


            $data = [
                'user_id' => Auth::user()->uuid,
                'local_id' => $local_id,
                'camera_id' => new \MongoDB\BSON\ObjectID($request->camera_id),
                'region_id' => new \MongoDB\BSON\ObjectID($region_id),
                'face_image' => $base64,
                'attendee_name' => $request->attendee_name,
                'attendee_email' => $request->attendee_email,
                'attendee_phone_number' => $request->attendee_phone_number,
                'attendee_address' => $request->attendee_address,
                'created_at' => $currentUtcDateTime,

            ];


            // insert into collection
            $insertResult = $collection->insertOne($data);
            $insertedId = $insertResult->getInsertedId();


            if ($insertResult->getInsertedCount() > 0) {
                // faces.face_detail
                return redirect()->route('faces.face_detail', $insertedId);
                // return redirect()->back()->with('success', 'Face image uploaded successfully.');
            } else {
                return redirect()->back()->with('error', 'Failed to upload face image. Please try again.');
            }
        } else {
            dd('region_id not found in camera data');
        }
        // }

        return redirect()->back()->with('error', 'Failed to upload face image.');
    }



    public function faces_all($camera_id = "")
    {


        $collection = $this->mongoDB->dataprocess->face_for_search;
        if ($camera_id == "") {

            $faces = $collection->find([], ['sort' => ['_id' => -1]])->toArray();
            return view("add.view_faces", compact('faces'));
        }

        $faces = $collection->find(['camera_id' => new \MongoDB\BSON\ObjectId($camera_id)], ['sort' => ['_id' => -1]])->toArray();
        return view("add.view_faces", compact('faces'));
    }


    public function delete_face($id)
    {


        $collection = $this->mongoDB->dataprocess->face_for_search;
        $result = $collection->deleteOne(['_id' => new \MongoDB\BSON\ObjectId($id)]);


        if ($result->getDeletedCount() > 0) {
            return redirect()->back()->with('success', 'Face record deleted successfully');
        } else {
            return redirect()->back()->with('error', 'Face record not found or could not be deleted');
        }
    }




    public function custom_alarm_configration(Request $request)
    {
        $collection = $this->mongoDB->dataprocess->camera_alarms_settings;

        $threshold_values = [
            '240' => '250',    // Medium quality threshold for 240p
            '360' => '600',    // Medium quality threshold for 360p
            '480' => '1000',   // Medium quality threshold for 480p
            '720' => '2000',   // Medium quality threshold for 720p
            '1080' => '4000',  // Medium quality threshold for 1080p
            '1440' => '6000',  // Medium quality threshold for 1440p
            '2160' => '10000'  // Medium quality threshold for 2160p (4K)
        ];


        $setThreshold_value = isset($threshold_values[$request->input('threshold_value')]) ? $threshold_values[$request->input('threshold_value')] : $request->input('threshold_value');



        $alarmConfig = [
            'camera_id' => new ObjectId($request->input('camera_id')),
            'region_id' => new ObjectId($request->input('region_id')),
            'user_id' => auth()->user()->uuid,
            'blur_detection' => $request->has('blur_detection') ? 1 : 0,
            'black_detection' => $request->has('black_detection') ? 1 : 0,
            'motion_detection' => $request->has('motion_detection') ? 1 : 0,
            'enable_disable_stream' => $request->has('enable_disable_stream') ? 1 : 0,
            'threshold' => $request->has('threshold') ? 1 : 0,
            'threshold_value' => $setThreshold_value,
            'latency' => $request->has('latency') ? 1 : 0,
            'latency_value' => $request->input('latency_value') ?? 1,
            'updated_at' => new \MongoDB\BSON\UTCDateTime(now()),
        ];





        // Log the configuration for debugging
        // \Log::info('Alarm Configuration:', $alarmConfig);

        try {
            // Check if a document already exists
            $existingConfig = $collection->findOne([
                'camera_id' => new ObjectId($request->camera_id),
                'user_uuid' => $request->input('user_uuid')
            ]);

            if ($existingConfig) {
                // Update existing document
                $result = $collection->updateOne(
                    [
                        'camera_id' => new ObjectId($request->camera_id),
                        'user_uuid' => $request->input('user_uuid')
                    ],
                    ['$set' => $alarmConfig]
                );
                $success = $result->getModifiedCount() > 0;
            } else {
                // Insert new document
                $result = $collection->insertOne($alarmConfig);
                $success = $result->getInsertedCount() > 0;
            }

            if ($success) {
                return redirect()->back()->with('success', 'Alarm configuration saved successfully.');
            } else {
                return redirect()->back()->with('info', 'No changes were made to the alarm configuration.');
            }
        } catch (\Exception $e) {
            \Log::error('Error saving alarm configuration: ' . $e->getMessage());
            return redirect()->back()->with('error', 'An error occurred while saving the alarm configuration.');
        }
    }


    public function verify_stream(Request $request)
    {
        if ($request->has('stream_url')) {
            $streamUrl = $request->stream_url;
            $response = ApiHelper::verify_stream(['stream_url' => $streamUrl, 'user_id' => auth()->user()->uuid]);
            return response()->json($response);
        } else {
            return response()->json([
                'error' => 'Stream URL not found',
            ]);
        }
    }

    public function face_detail($face_id)
    {
        $collection = $this->mongoDB->dataprocess->face_for_search;
        $region_collection = $this->mongoDB->dataprocess->regions;
        $camera_collection = $this->mongoDB->dataprocess->cameras;

        // Fetch the face record
        $record = $collection->findOne(
            ['_id' => new \MongoDB\BSON\ObjectID($face_id)]
        );

        // Fetch related camera record
        if (isset($record['camera_id'])) {
            $camera = $camera_collection->findOne(
                ['_id' => new \MongoDB\BSON\ObjectID($record['camera_id'])]
            );
            $record['camera'] = $camera; // Add camera details to the record
        }

        // Fetch related region record
        if (isset($record['region_id'])) {
            $region = $region_collection->findOne(
                ['_id' => new \MongoDB\BSON\ObjectID($record['region_id'])]
            );
            $record['region'] = $region; // Add region details to the record
        }

        return view('add.face_detail', compact('record'));
    }

    public function extact_frame_faces(Request $request)
    {
        if ($request->has('photo_frame_base64')) {
            $photo_frame_base64 = $request->photo_frame_base64;
            // \Log::info($photo_frame_base64);
            $response = ApiHelper::extact_frame_faces(['photo_frame_base64' => $photo_frame_base64]);
            return response()->json($response);
        } else {
            return response()->json([
                'error' => 'Stream URL not found',
            ]);
        }
    }
}
