<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use MongoDB\Client as MongoDBClient;


class AjaxController extends Controller
{
    private $mangoDb;

    public function __construct(MongoDBClient $mongoDB)
    {
        $this->middleware('auth');
        $this->mangoDb = $mongoDB;
    }

    public function totalCameras()
    {
        $collection = $this->mangoDb->dataprocess->cameras;
        $allcameras = $collection->countDocuments();
        $activeCameras = $collection->countDocuments(['status' => 1]);
        $disconnectedCameras = $collection->countDocuments(['status' => 0]);

        $collectionRegion = $this->mangoDb->dataprocess->regions;
        $totalRegions = $collectionRegion->countDocuments();
        return response()->json([
            'allcameras' => $allcameras,
            'activeCameras' => $activeCameras,
            'disconnectedCameras' => $disconnectedCameras,
            'total_regions'=>$totalRegions ,
        ]);

    }


    public function LoadGenderAgeData()
    {
        $collection = $this->mangoDb->dataprocess->imagesinfo;


        $filter = [];

        $projection = [
            'actual_frame_path' => 0,
            'frame_image' => 0,
            'created_at' => 0,
            "frame_id" => 0,
            "_id" => 0,
            "face_details.BoundingBox" => 0,
            "face_details.Smile" => 0,
            "face_details.Eyeglasses" => 0,
            "face_details.Sunglasses" => 0,
            "face_details.Beard" => 0,
            "face_details.Mustache" => 0,
            "face_details.MouthOpen" => 0,
            "face_details.EyesOpen" => 0,
            "face_details.Emotions" => 0,
            "face_details.Landmarks" => 0,
            "face_details.Pose" => 0,
            "face_details.Quality" => 0,
            "face_details.FaceOccluded" => 0,
            "face_details.EyeDirection" => 0,
            // ]
        ];

        $options = [];

        $cursor = $collection->find($filter, ['projection' => $projection] + $options);
        //
        $genderData = [];
        $ageData = [];

        foreach ($cursor as $result) {
            $genderData[] = $result['face_details']['Gender']['Value'];
            $ageData[] = $result['face_details']['AgeRange'];
        }

        return response()->json(['data' => $genderData, 'age'=>$ageData]);
    }
}
