<?php

namespace App\Http\Controllers;

use App\Helper\MongoHelper;
use Illuminate\Http\Request;
use MongoDB\Client as MongoDBClient;


class AlarmController extends Controller
{


    protected $mongoDB;
    protected $mongoHelper;

    public function __construct(MongoDBClient $mongoDB)
    {
        $this->middleware('auth');
        $this->mongoDB = $mongoDB;
        $this->mongoHelper = new  MongoHelper($this->mongoDB);
    }

    public function index()
    {

        // $result = $this->mongoHelper->findCamera($camera_id, auth()->user()->uuid);
        // $collection = $this->mongoDB->dataprocess->alarms_settings;

        // $settings = $collection->find(
        //     [
        //         'camera_id' => $camera_id,
        //         'user_id' => auth()->user()->uuid
        //     ]
        // );

        // if (count($result) <= 0) {
        //     session()->flash("error", "Sorry invalid camera details");
        //     return back();
        // }

        // $result =  $result[0];
        // $settings = $settings->toArray();
       // return view('settings.alarm.alarm', compact('result', 'settings','camera_id'));
        return view('settings.alarm.alarm');
    }

    public function update_settings(Request $request)
    {

        // echo json_encode($request->all());
        // $request->validate([
        //     'camera' => 'required|string'
        // ]);

        // $result = $this->mongoHelper->findCamera($request->camera, auth()->user()->uuid);

        // if (count($result) <= 0) {
        //     session()->flash("error", "Sorry invalid camera details");
        //     return back();
        // }

    

        if ($request->id) {
            $collection = $this->mongoDB->dataprocess->alarms_settings;
            
            // When already setting data is avaiable 
        } else {
            $collection = $this->mongoDB->dataprocess->alarms_settings;
            $data = [
                'user_id' => auth()->user()->uuid,
               // 'camera_id' => $request->camera,
                'stop_stream' => $request->stop_stream ? true : false,
                'enable_disable_stream' => $request->enable_disable_stream ? true : false,
                'black_screen' => $request->black_screen ? true : false,
                'blur_screen' => $request->blur_screen ? true : false,
                'threshhold' => $request->threshhold ? true : false,
                'threshhold_value' => $request->threshhold_value,
                'latancy' => $request->latancy,
                'latency_value' => $request->latency_value,
            ];

            $result =  $this->mongoHelper->insertDataToCollection($data, $collection);
           
            if ($result ) {
                session()->flash("success", "Alarm updated successfully");
            } else {
                session()->flash("error", "Sorry try again");
            }

            return redirect(url('video-enrichment'));
        }
    }
}
