<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use MongoDB\Client as MongoDBClient;

class AlarmDetectController extends Controller
{

    protected $mongoDB;

    public function __construct(MongoDBClient $mongoDB)
    {
        $this->middleware('auth');
        $this->mongoDB = $mongoDB;
    }

    public function index($camera_id,$type){


        $search_type = "";
        if($type=="black"){
            $search_type = "black_detected";
        }else if($type=="blur"){
            $search_type = "blur_detected";
        }else if($type=="motion"){
                $search_type = "motion_detected";
        }else{
            session()->flash('error',"Sorry invalid data");
            return back();
        }

        $collection = $this->mongoDB->dataprocess->stream_alram_alerts;

        $alarm_list = $collection->find([
            'camera_id' => new \MongoDB\BSON\ObjectID($camera_id),
            'alarm_type'=>$search_type
            //'user_id' => auth()->user()->uuid
        ]);

        return view("streams.detection",compact('alarm_list'));
    }

}
