<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helper\HelperData;
use App\Helper\MongoHelper;

use Illuminate\Support\Facades\Auth;
use MongoDB\Client as MongoDBClient;
use MongoDB\BSON\ObjectId;

class MotionDetectionController extends Controller
{
    protected $mongoDB;
    protected $mongoHelper;
    public function __construct(MongoDBClient $mongoDB)
    {
        $this->mongoDB = $mongoDB;
        $this->mongoHelper = new MongoHelper($this->mongoDB);
    }

    public function index()
    {
        $regions_collection = $this->mongoDB->dataprocess->regions;
        $cameras_collection = $this->mongoDB->dataprocess->cameras;


        $current_user_uuid = auth()->user()->uuid;
        $regions = $regions_collection->find(['uuid' => $current_user_uuid])->toArray();
        $cameras = $cameras_collection->find(['user_id' => $current_user_uuid])->toArray();


        return view('motion_detection/index', compact('regions', 'cameras'));
    }

    public function getMotionDetectionDetails_camera($camera_id)
    {

        if (!$camera_id) {
            return response()->json('camera id not found');
        }

        $motion_detection_collection = $this->mongoDB->dataprocess->motion_detection;
        $cameras = $this->mongoDB->dataprocess->cameras;
        $regions = $this->mongoDB->dataprocess->regions;


        $cameraObjectId = new ObjectId($camera_id);
        $cameraInMotionDetection = $motion_detection_collection
            ->find(['camera_id' => $cameraObjectId], ['sort' => ['created_at' => -1]])
            ->toArray();

        // $cameraInCameras = $cameras->findOne(['_id' => $cameraObjectId]);
        $cameraInCameras = $cameras->findOne([
            '_id' => $cameraObjectId,
            'is_allow_emotion_detection' => 1
        ]);


        $regionObjectId = new ObjectId($cameraInCameras['region_id']);

        $region = $regions->findOne(['_id' => $regionObjectId]);


        if (empty($cameraInMotionDetection) || empty($cameraInCameras)) {  # check region_id exist in regions & motion_detection collection
            return response()->json('camera not found in db');
        }


        $cameras_collection = $this->mongoDB->dataprocess->cameras;
        $camerasInfo = []; #only cameras info
        foreach ($cameraInMotionDetection as $motion_detection) {
            $camera = $cameras_collection->findOne(['_id' => $motion_detection['camera_id']]); // find camera in cameras collection based on motion_detection collection camera_id

            if ($camera) {
                // Add new camera along with region_name and motion_detect_path
                $camera['region_name'] = $region['region'];
                $camera['motion_detect_path'] = $motion_detection['motion_detect_path'];
                $camera['motion_created_at'] = $motion_detection['created_at'] ?? "";

                $camerasInfo[] = $camera; // add new camera
            }
        }

        return response()->json($camerasInfo);
    }

    public function getMotionDetectionDetails_region($region_id)
    {

        if (!$region_id) {
            return response()->json('region id not found');
        }

        $motion_detection_collection = $this->mongoDB->dataprocess->motion_detection;
        $regions_collection = $this->mongoDB->dataprocess->regions;

        $regionObjectId = new ObjectId($region_id);
        $regionInMotionDetection = $motion_detection_collection
            ->find(['region_id' => $regionObjectId], ['sort' => ['created_at' => -1]])
            ->toArray();

        $regionInRegions = $regions_collection->findOne(['_id' => $regionObjectId]);


        if (empty($regionInMotionDetection) || empty($regionInRegions)) {  # check region_id exist in regions & motion_detection collection
            return response()->json('region not found in db');
        }


        $cameras_collection = $this->mongoDB->dataprocess->cameras;
        $camerasInfo = []; #only cameras info
        foreach ($regionInMotionDetection as $motion_detection) {
            $camera = $cameras_collection->findOne(['_id' => $motion_detection['camera_id']]); // find camera in cameras collection based on motion_detection collection camera_id

            if ($camera) {
                // Add new camera along with region_name and motion_detect_path
                $camera['region_name'] = $regionInRegions['region'];
                $camera['motion_detect_path'] = $motion_detection['motion_detect_path'];
                $camera['motion_created_at'] = $motion_detection['created_at'] ?? "";

                $camerasInfo[] = $camera; // add new camera
            }
        }

        return response()->json($camerasInfo);
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
