<?php

namespace App\Http\Controllers;

use App\Events\FaceDetected;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use MongoDB\Client as MongoDBClient;
use App\Helper\HelperData;
use Illuminate\Support\Facades\Log;
use MongoDB\BSON\UTCDateTime;
use Pusher\Pusher;

class SearchController extends Controller
{

    protected $mongoDB;

    public function __construct(MongoDBClient $mongoDB)
    {

     //   $this->middleware('auth');
        $this->mongoDB = $mongoDB;
    }


    public function index()
    {
        return view("search.search");
        // return view("test-design.test");
    }

    public function searchByAgeGender($request)
    {

    }


    public function search_face_byId($id)
    {
        $collection = $this->mongoDB->dataprocess->photo_face_detect;

        $result = $collection->find(
            [
                '_id' => new \MongoDB\BSON\ObjectID($id)
            ]
        );


        foreach ($result as $key => $d) {

            $created_at_timestamp = $d->created_at->toDateTime()->getTimestamp(); // Convert BSON date to UNIX timestamp
            // Create a DateTime object using the timestamp
            $created_at = (new \DateTime())->setTimestamp($created_at_timestamp);

            // Format the date to a specific format (e.g., 'Y-m-d H:i:s')
            $formatted_created_at = $created_at->format('Y-m-d H:i:s');
            $data = [
                'status' => 200,
                'face_image' => $d->detected_face_frame,
                'created_at' => $formatted_created_at,
                'id' => $d->_id,
            ];
        }

        echo json_encode($data);

    }

    public function testEventData(Request $request)
    {
        //return json_encode(["status"=>"don"]);
        // Create a Pusher instance


        // Assuming $channels, $event, and $data are defined earlier


        // $jsonData = $request->json()->all();

        // // Decode the JSON string
        // $response = json_decode($jsonData, true);


        // if ($request->status == 200) {

        //     $collection = $this->mongoDB->dataprocess->imagesinfo;

        //     $result = $collection->find(
        //         [
        //             '_id' => new \MongoDB\BSON\ObjectID($request->_id)
        //         ]
        //     );

        //     foreach ($result as $d) {

        //         $data = [
        //             'status' => 200,
        //             'result' => $->dropTable(tableName)
        //         ];
        //     }

        // } else {
        //     $data = [
        //         'status' => "204",
        //     ];

        // }

        Log::info($request->all());

        if ($request->status == 200) {
            $data = [
                'status' => 200,
                'id' => $request->_id
            ];
        } else {
            $data = [
                'status' => 204,
            ];
        }

        $pusher = new Pusher("ca1218220a807246d881", "9c77f5f9a8af8c535f0e", "1046092", [
            'cluster' => "ap2",
            // other configuration options...
        ]);

        $pusher->trigger("my-channel","my-event", $data, []);

        //event(new FaceDetected($data));

    }

    public function search(Request $request)
    {
        Log::info($request->all());

        if (!$request->datetime && !$request->end_datetime) {

            $data = [
                'status' => 204,
                'message' => "Start and end datetime is required"
            ];
            echo json_encode($data);
            exit;
        }

        $query = "";
        $collection = $this->mongoDB->dataprocess->photo_face_detect;

        if ($request->start_age) {

            
        }



        if ($request->file('face_img')) {

            $file = $request->file('face_img');
            $imageName = time() . '.' . $file->getClientOriginalExtension();

            $file->move(public_path('images'), $imageName);
            $imagePath = public_path('images/' . $imageName);
            //echo  $imagePath;
            $apiUrl = HelperData::$FACE_MATCHING_URL_FACE_FIND; // Replace with your Python API URL
            $response = Http::attach('file', file_get_contents($imagePath), $imageName)
                ->post($apiUrl, $request->all());
            $response = json_decode($response, true);

            echo json_encode($response);
            exit;
        } else {
            //echo  $imagePath;
            $apiUrl = HelperData::$FACE_MATCHING_URL_FIND_DATA; // Replace with your Python API URL
            $response = Http::asForm()->post($apiUrl, $request->all());
            $response = json_decode($response, true);
            echo json_encode($response);
            exit;
        }

        // $data = [
        //     'status' => 200,
        //     'message' => "searching is done"
        // ];

        //  echo json_encode($data);
        // exit;

    }


}
