<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class MongoDBServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton('mangodb', function () {
            $uri = "mongodb://localhost:27017"; // Replace with your local MongoDB server's address and port
            return  new MongoDB\Client($uri, [], ['typeMap' => ['root' => 'array', 'document' => 'array']]);
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
