<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class Base64Validation implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        base64_encode(base64_decode($value, true)) === $value;
    }

    public function passes($attribute, $value)
    {
        return 
    }

    public function message()
    {
        return 'The :attribute is not a valid Base64 string.';
    }
}
