@extends('layouts.master')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <h5 class="card-header card-title">Add New Camera</h5>
            <div class="table-responsive text-nowrap">
                <form action="{{ route('camera.save') }}" method="POST">
                    @csrf

                    <div class="row" style="margin: 10px;">

                        <input type="hidden" name="region"
                            @foreach ($regions as $list)
                               value="{{ $list->_id }}" @endforeach" />

                        <div class="col-md-6">
                            <label>Select Region</label>
                            <div class="form-group" style="display: flex;">
                                <input class="form-control" readonly disabled
                                    @foreach ($regions as $list)
                                    value="{{ $list->region }}" /> @endforeach
                                    </div>
                            </div>


                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Camera Name</label>
                                    <input type="text" placeholder="Enter Camera Name" required
                                        class="form-control @error('camera') is-invalid @enderror" name="camera"
                                        value="{{old('camera')}}"
                                        />
                                    @if ($errors->has('camera'))
                                        <b style="color:#ff3e1d;">{{ $errors->first('camera') }} </b>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-12" style="margin-top: 10px;">
                                <div class="form-group">
                                    <label>Stream Url
                                         {{-- <small style="color: red;">(format=http://192.168.10.2:80)</small> --}}
                                        </label>
                                    <input type="url" placeholder="Enter Streamming URL" required
                                        value="{{old('url')}}"
                                        class="form-control @error('url') is-invalid @enderror" name="url" />
                                    @if ($errors->has('url'))
                                        <b style="color:#ff3e1d;">{{ $errors->first('url') }} </b>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-12" style="margin-top:20px;">
                                <div class="form-check form-switch mb-2" style="margin-top: 15px;height: 70px;">
                                    <input class="form-check-input bg-success" type="checkbox" id="flexSwitchCheckChecked"
                                        checked="" name="status" style="height: 46px;width: 98px;">
                                    <label style=" margin-left: 21px; font-size: 19px; margin-top: 10px; "
                                        class="form-check-label" for="flexSwitchCheckChecked">On/Off Streaming Session</label>
                                </div>
                            </div>

                        </div>

                        <div class="row" style="margin: 50px;display: block;text-align: center;;">
                            <input style="width:150px;" type="submit" value="Submit" class="btn btn-default" />
                        </div>
                </form>

            </div>

            <div class="row">
                <h5>Sample Videos</h5>
                <a href="https://video.codxcanvas.com/people.mp4">https://video.codxcanvas.com/people.mp4</a><br>
                <a href="https://video.codxcanvas.com/sample1.mp4">https://video.codxcanvas.com/sample1.mp4</a><br>
                <a href="https://video.codxcanvas.com/sample1.mp4">https://video.codxcanvas.com/sample1.mp4</a><br>
            </div>

        </div>


        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
        </div>


    </div>
    </div>
    </div>

@section('script_section')
    <script>
        $(document).ready(function() {
            $('#mySelect').select2();
        });
    </script>
@endSection
@endSection
