@extends('layouts.master')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <h5 class="card-header" style="color:black;">Update Camera</h5>
            <div class="table-responsive text-nowrap">
                <form action="{{ route('camera.update') }}" method="POST">
                    @csrf
                  
                    <input type="hidden" name="id" value="{{ $data['_id'] }}" />
                    <input type="hidden" name="region" value="{{ $data['region_id'] }}" />

                    <div class="row" style="margin: 10px;">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Camera Name</label>
                                <input type="text" value="{{ old('camera', $data['cameraname']) }}"
                                    placeholder="Enter Camera Name" required
                                    class="form-control @error('camera') is-invalid @enderror" name="camera" />
                                @if ($errors->has('camera'))
                                    <b style="color:#ff3e1d;">{{ $errors->first('camera') }} </b>
                                @endif

                            </div>
                        </div>

                        <div class="col-md-12" style="margin-top: 10px;">
                            <div class="form-group">
                                <label>Stream Url</label>
                                <input type="url" value="{{ old('url', $data['stream_url']) }}"
                                    placeholder="Enter Streamming URL" required
                                    class="form-control @error('camera') is-invalid @enderror" name="url" />
                                @if ($errors->has('url'))
                                    <b style="color:#ff3e1d;">{{ $errors->first('url') }} </b>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-12" style="margin-top:10px;">
                            <div class="form-check form-switch mb-2" style="margin-top: 15px;height: 70px;">
                                <input class="form-check-input" type="checkbox" {{ $data['status'] ? 'checked' : '' }}
                                    id="flexSwitchCheckChecked" name="status" style="height: 46px;width: 98px;">
                                <label style=" margin-left: 21px; font-size: 19px; margin-top: 10px; "
                                    class="form-check-label" for="flexSwitchCheckChecked">On/Off Streaming Session</label>
                            </div>
                        </div>

                    </div>

                    <div class="row" style="margin: 50px;display: block;text-align: center;;">
                        <input style="width:150px;" type="submit" value="Submit" class="btn btn-primary" />
                    </div>
                </form>

            </div>

        </div>


        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
        </div>


    </div>
    </div>
    </div>
@endSection
