@extends('layouts.master')
@section('content')
    {{-- <div class="container-xxl flex-grow-1 container-p-y">
        <h5 style="color:black;">Regions List</h5>
        <div class="card" style="display: grid;height: 100%;">

            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr class="text-nowrap">
                            <th>#</th>
                            <th>Region Name</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if ($result)
                            @foreach ($result as $index => $list)
                                <tr>
                                    <th scope="row">{{ ++$index }}</th>

                                    <td>{{ $list['region'] }}</td>

                                    <td>
                                        @if (isset($list['status']) && $list['status'] == 1)
                                            <span class="badge bg-success ">Active</span>
                                        @else
                                            <span class="badge bg-danger badge-sm">Disabled</span>
                                        @endif
                                    </td>
                                    <td>{{ App\Helper\HelperData::convertTimeStamp($list['created_at']) }}</td>
                                    <td>
                                        <div class="dropdown">
                                            <a role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i class="menu-icon tf-icons bx bx-dots-vertical-rounded"></i>
                                            </a>
                                            <ul class="dropdown-menu">
                                                <li><a class="dropdown-item"
                                                        href="{{ route('find.region', [$list['_id']]) }}">
                                                        <i class="menu-icon tf-icons bx bx-edit"></i>Edit</a></li>
                                                <li>
                                                    <a class="dropdown-item"
                                                        href="{{ route('camera.add', [$list['_id']]) }}">
                                                        <i class="menu-icon tf-icons bx bx-add-to-queue"></i> New
                                                        Camera/Stream</a>
                                                </li>

                                                <li>
                                                    <a class="dropdown-item"
                                                        href="{{ route('all.cameras.lists',[$list['_id']]) }}">
                                                        <i class="menu-icon tf-icons bx bx-list-ul"></i>Stream/Camera List</a>
                                                </li>

                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>

        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
        </div>

    </div> --}}
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Regions List</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="example4" class="display" style="min-width: 845px">
                        <thead>
                            <tr class="text-nowrap">
                                <th>#</th>
                                <th>Region Name</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($result as $index => $list)
                                <tr>
                                    <th scope="row">{{ ++$index }}</th>

                                    <td>{{ $list['region'] }}</td>

                                    <td>
                                        @if (isset($list['status']) && $list['status'] == 1)
                                            <span class="badge bg-success ">Active</span>
                                        @else
                                            <span class="badge bg-danger badge-sm">Disabled</span>
                                        @endif
                                    </td>
                                    <td>{{ App\Helper\HelperData::convertTimeStamp($list['created_at']) }}</td>
                                    <td>

                                        <div class="dropdown ms-auto text-end">
                                            <div class="btn-link" data-bs-toggle="dropdown">
                                                <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                        <rect x="0" y="0" width="24" height="24"></rect>
                                                        <circle fill="#ffffff" cx="5" cy="12" r="2"></circle>
                                                        <circle fill="#ffffff" cx="12" cy="12" r="2"></circle>
                                                        <circle fill="#ffffff" cx="19" cy="12" r="2"></circle>
                                                    </g>
                                                </svg>
                                            </div>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item"
                                                    href="{{ route('find.region', [$list['_id']]) }}">Edit</a>
                                                <a class="dropdown-item"
                                                    href="{{ route('camera.add', [$list['_id']]) }}">New
                                                    Camera/Stream</a>
                                                <a class="dropdown-item"
                                                    href="{{ route('all.cameras.lists', [$list['_id']]) }}">Stream/Camera
                                                    List</a>
                                            </div>
                                        </div>


                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th>Region Name</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>




                {{-- </div> --}}
            </div>
        </div>
    @endSection
