@extends('layouts.master')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">

        @if (isset($region))
            <div class="row" style="display: flow-root">
                <h5 class="card-title">Cameras List</h5>
                <a href="{{ route('camera.add', $region) }}"
                    style="width: fit-content;float: right;margin-bottom: 12px;margin-right:17px;"
                    class="btn btn-primary btn-xs">
                    <i class="menu-icon tf-icons bx bx-message-square-add"></i>New Camera
                </a>
            </div>
        @endif
        <div class="card" style="display: grid;height: 100%;">
            <div class="table-responsive text-nowrap" style="display: inline-table !important;">
                <table class="display table " style="height: 100%;">
                    <thead>
                        <tr class="text-nowrap">
                            <th>#</th>
                            <th>Camera Name</th>
                            <th>Date Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if ($result)
                            @foreach ($result as $index => $list)
                                <tr>
                                    <th scope="row">{{ ++$index }}</th>
                                    <td> <img src="data:image/png;base64,{{$list['face_photo']}}" />  </td>
                                    <td>{{ App\Helper\HelperData::convertTimeStamp($list['created_at']) }}</td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
            {{-- <a href="" class="btn btn-secondary" style="width: 150px;margin-right: 50px;">Back</a> --}}
            {{-- <a href="" class="btn btn-primary" style="width: 150px;">Next</a> --}}
        </div>


    </div>
    </div>
    </div>


    <script>
        function deleteCamera(id) {
            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('delete/camera/') }}/" + id;
                }
            });
        }
    </script>


@endSection
