@extends('layouts.master_two')
@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        #canvas {
            border: 1px solid black;
        }

        /* Custom styles for the range input */
        input[type="range"] {
            -webkit-appearance: none;
            width: 100%;
            height: 8px;
            border-radius: 5px;
            background: #ddd;
            outline: none;
            opacity: 0.7;
            -webkit-transition: .2s;
            transition: opacity .2s;
        }

        input[type="range"]::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 25px;
            height: 25px;
            border-radius: 50%;
            background: #007bff;
            /* Bootstrap primary color */
            cursor: pointer;
        }

        input[type="range"]::-moz-range-thumb {
            width: 25px;
            height: 25px;
            border-radius: 50%;
            background: #007bff;
            /* Bootstrap primary color */
            cursor: pointer;
        }

        input[type="range"]::-ms-thumb {
            width: 25px;
            height: 25px;
            border-radius: 50%;
            background: #007bff;
            /* Bootstrap primary color */
            cursor: pointer;
        }
    </style>

    <style>
        /* This will ensure that the video is displayed in its actual size */
        video {
            display: block;
            max-width: none;
            width: auto;
            /* Let the video width be auto so it adjusts to its actual resolution */
            height: auto;
            /* Let the video height be auto so it adjusts to its actual resolution */
        }
    </style>
    <style>
        .video-container {
            position: relative;
            display: inline-block;
        }

        video {
            display: block;
            width: 100%;
            /* Ensure the video fits within its container */
        }

        canvas {
            position: absolute;
            top: 0;
            left: 0;
            pointer-events: auto;
            /* Allow mouse events on canvas */
            border: 1px solid black;
            /* Optional: to visualize the canvas boundary */
        }
    </style>

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- @dd($result->video_type) --}}
        <div class="card" style="display: grid;height: 100%;">

            <div class="row" style=" padding: 0px; margin: 0px; ">
                {{-- <video id="videoElement" style="width: {{$streamInfo[0]->width}}px; height: {{$streamInfo[0]->height}}px;" controls>
                    <source src="{{ $result['stream_url'] }}" type="video/mp4">
                    Your browser does not support the video tag.
                </video> --}}

                @if ($result->video_type == 'normal')
                    @php
                        // Define the MIME types for video and image formats
                        $allVideoFormat = [
                            'mpd' => 'application/dash+xml',
                            'mp4' => 'video/mp4',
                            'webm' => 'video/webm',
                            'ogg' => 'video/ogg',
                            'm3u8' => 'application/x-mpegURL',
                            'mjpeg' => 'video/x-motion-jpeg',
                            'avi' => 'video/x-msvideo',
                            'mov' => 'video/quicktime',
                            'mkv' => 'video/x-matroska',
                            '3gp' => 'video/3gpp',
                            '3g2' => 'video/3gpp2',
                            'asf' => 'video/x-ms-asf',
                            'flv' => 'video/x-flv',
                            'f4v' => 'video/x-f4v',
                            'ts' => 'video/mp2t',
                            'mpeg' => 'video/mpeg',
                            'mpg' => 'video/mpeg',
                            'wmv' => 'video/x-ms-wmv',
                            'divx' => 'video/divx',
                            'xvid' => 'video/xvid',
                            'vob' => 'video/dvd',
                            'mts' => 'video/avchd',
                            'm2ts' => 'video/avchd',
                            'hevc' => 'video/hevc',
                            'h264' => 'video/h264',
                            'h265' => 'video/h265',
                            'dv' => 'video/x-dv',
                            'rm' => 'application/vnd.rn-realmedia',
                            'rv' => 'video/vnd.rn-realvideo',
                            'drc' => 'video/x-dirac',
                        ];

                        $allImageFormat = [
                            'jpg' => 'image/jpeg',
                            'jpeg' => 'image/jpeg',
                            'png' => 'image/png',
                            'gif' => 'image/gif',
                            'bmp' => 'image/bmp',
                            'webp' => 'image/webp',
                            'svg' => 'image/svg+xml',
                            'cgi' => 'image/cgi',
                        ];

                        // Get the file extension from the stream URL
                        $fileExtension = pathinfo($result['stream_url'], PATHINFO_EXTENSION);
                        $mimeType = null;
                        // echo $fileExtension;
                        // Check if the file is a video or image based on the extension
                        if (array_key_exists($fileExtension, $allVideoFormat)) {
                            $mimeType = $allVideoFormat[$fileExtension];
                        } elseif (array_key_exists($fileExtension, $allImageFormat)) {
                            $mimeType = $allImageFormat[$fileExtension];
                        }
                    @endphp

                    @if ($mimeType && strpos($mimeType, 'video') !== false)
                        {{-- <div style="position: relative; display: inline-block;" class="d-flex justify-content-center">
                        <video id="videoElement" style="width: 1060px; height: 765px;" controls>
                            <source src="{{ $result['stream_url'] }}" type="{{ $mimeType }}">
                            Your browser does not support the video tag.
                        </video>
                        <canvas id="canvasElement" style="position: absolute; top: 0; left: 0;"></canvas>
                    </div> --}}

                        <div style="position: relative; width: fit-content; margin: 0 auto;"
                            class="d-flex justify-content-center">
                            <video id="videoElement" style="display: block; width: 1060px; height: 100%;" controls>
                                <source src="{{ $result['stream_url'] }}" type="{{ $mimeType }}">
                                Your browser does not support the video tag.
                            </video>
                            <canvas id="canvasElement"
                                style="position: absolute; top: 0; left: 0; width: 100%; height: 90%; border: none"></canvas>
                        </div>
                    @elseif ($mimeType && strpos($mimeType, 'image') !== false)
                        {{-- <div style="position: relative; display: inline-block;" class="d-flex justify-content-center">

                            <img src="{{ $result['stream_url'] }}" id="videoElement"
                                style="width: 1060px; height: 765px;" alt="Image">
                            <canvas id="canvasElement" style="position: absolute; top: 0; left: 0; border: none;"></canvas>

                        </div> --}}
                        <div style="position: relative; width: fit-content; margin: 0 auto;"
                            class="d-flex justify-content-center">
                            <img src="{{ $result['stream_url'] }}" id="videoElement"
                                style="width: 1060px; height: 100%; display: block;" alt="Image">
                            <canvas id="canvasElement"
                                style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; pointer-events:none;"></canvas>
                        </div>
                    @else
                        <!-- Unsupported file type -->
                        <p>Unsupported file type.</p>
                    @endif
                @elseif ($result->video_type == 'youtube')
                    @php
                        $url = $result['stream_url']; // Full YouTube URL
                        $videoId = null;

                        // Parse the YouTube URL and extract video ID
                        $parsedUrl = parse_url($url);
                        parse_str($parsedUrl['query'] ?? '', $queryParams);

                        // Extract the video ID from query parameters
                        if (isset($queryParams['v'])) {
                            $videoId = $queryParams['v'];
                        }
                    @endphp

                    <!-- YouTube video iframe rendering -->
                    <iframe width="{{ $streamInfo[0]->width }}" height="{{ $streamInfo[0]->height }}"
                        src="https://www.youtube.com/embed/{{ $videoId }}" frameborder="0" allowfullscreen></iframe>
                @endif

                {{-- <canvas id="canvasElement">
                    </canvas> --}}

            </div>

            <div class="row" style=" text-align: center; padding: 24px; display: block;">

                <form id="dataForm" action="{{ route('attendance.line') }}" method="post">
                    @csrf
                    <label for="start_x">Starting Point X-coordinate:</label>
                    <input type="number" id="start_x" name="start_x" />

                    <label for="start_y">Starting Point Y-coordinate:</label>
                    <input type="number" id="start_y" name="start_y" />

                    <label for="end_x">Ending Point X-coordinate:</label>
                    <input type="number" id="end_x" name="end_x" />

                    <label for="end_y">Ending Point Y-coordinate:</label>
                    <input type="number" id="end_y" name="end_y" />
                    <input type="hidden" id="color" name="color" />
                    <input type="hidden" id="width" name="width" />
                    <button type="submit" class="btn btn-info btn-sm">Create Line</button>
                </form>

            </div>
            <div id="loading" style=" text-align: center; padding: 51px;display: none;">
                <img src="{{ asset('infinite-spinner.svg') }}" style="width:300px;" />
            </div>

        </div>
    </div>


    <script>
        //         const video = document.getElementById('videoElement');
        //         const canvas = document.getElementById('canvasElement');
        //         const ctx = canvas.getContext('2d');

        //         let lineY;
        //         let isDragging = false;

        //         // Set the canvas dimensions to match the video dimensions
        //         window.onload = function() {
        //             canvas.width = 1140;
        //             canvas.height = video.videoHeight - 10;
        //             drawLine();
        // };


        //         // Draw the line
        //         function drawLine() {
        //             ctx.clearRect(0, 0, canvas.width, canvas.height);
        //             ctx.strokeStyle = 'red';
        //             ctx.lineWidth = 2;
        //             ctx.beginPath();
        //             ctx.moveTo(0, lineY);
        //             ctx.lineTo(canvas.width, lineY);
        //             ctx.stroke();
        //         }

        //         // Start dragging on mouse down
        //         canvas.addEventListener('mousedown', function(e) {
        //             if (e.button !== 0) return;
        //             isDragging = true;
        //         });

        //         // Move the line on mouse move
        //         canvas.addEventListener('mousemove', function(e) {
        //             if (!isDragging) return;
        //             lineY = e.offsetY;
        //             drawLine();
        //         });

        //         // Stop dragging on mouse up
        //         canvas.addEventListener('mouseup', function(e) {
        //             if (!isDragging) return;
        //             isDragging = false;

        //             // Save coordinates to hidden form fields
        //             document.getElementById('start_x').value = lineY;
        //             document.getElementById('start_y').value = 0;
        //             document.getElementById('end_x').value = lineY;
        //             document.getElementById('end_y').value = canvas.width;
        //             document.getElementById('color').value = 'red';
        //             document.getElementById('width').value = 2;
        //         });


        const video = document.getElementById('videoElement');
        const canvas = document.getElementById('canvasElement');
        const ctx = canvas.getContext('2d');

        let lineY;
        let isDragging = false;

        // Set the canvas dimensions to match the video dimensions
        window.onload = function() {
            canvas.width = 1140;
            canvas.height = video.videoHeight - 10;
            drawLine();
        };

        // Draw the line
        function drawLine() {
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            ctx.strokeStyle = 'red';
            ctx.lineWidth = 2;
            ctx.beginPath();
            ctx.moveTo(0, lineY); // Start from the left side at lineY
            ctx.lineTo(canvas.width, lineY); // End at the right side at lineY
            ctx.stroke();
        }

        // Start dragging on mouse down
        canvas.addEventListener('mousedown', function(e) {
            if (e.button !== 0) return;
            isDragging = true;
        });

        // Move the line on mouse move
        canvas.addEventListener('mousemove', function(e) {
            if (!isDragging) return;
            lineY = e.offsetY;
            drawLine();
        });

        // Stop dragging on mouse up
        canvas.addEventListener('mouseup', function(e) {
            if (!isDragging) return;
            isDragging = false;

            // Save coordinates to hidden form fields
            document.getElementById('start_x').value = 0; // Fixed to 0 (horizontal line start at x=0)
            document.getElementById('start_y').value = lineY; // Use lineY for Y position
            document.getElementById('end_x').value = canvas.width; // End X position of the canvas width
            document.getElementById('end_y').value = lineY; // Use lineY for Y position
            document.getElementById('color').value = 'red';
            document.getElementById('width').value = 2;

            console.log('Start Coordinates: (' + 0 + ', ' + lineY + ')');
            console.log('End Coordinates: (' + canvas.width + ', ' + lineY + ')');
        });


        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('dataForm');
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                const formData = new FormData(form);
                const data = {};
                formData.forEach((value, key) => {
                    data[key] = value;
                });

                fetch('{{ route('attendance.line') }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify(data)
                    })
                    .then(response => response.json())
                    .then(data => {
                        document.getElementById('loading').style.display = "none";
                        if (data.status == 200) {
                            Swal.fire({
                                title: "Good job!",
                                text: "Line is created successfully",
                                icon: "success"
                            });
                        } else {
                            Swal.fire({
                                title: "Error!",
                                text: "Sorry try again",
                                icon: "error"
                            });
                        }
                    }).catch(error => {
                        document.getElementById('loading').style.display = "none";
                        console.error('Error:', error);
                    });
            });
        });
    </script>


@endsection
