@extends('layouts.master')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <h5 class="card-header" style="color:black;">First Time Stream Details</h5>

            <div class="row" style=" margin: 16px; ">
                <div class="col-md-12">
                    <h6 style="color:black;">General</h6>
                    <div class="card shadow">
                        <div class="card-body" style="font-size: 10px;">
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="text-start">URL</label>
                                </div>
                                <div class="col-md-6">
                                    <label class="text-end">{{ $result->info->format->filename }}</label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <label class="text-start">Bit Rate</label>
                                </div>
                                <div class="col-md-6">
                                    <label class="text-end">{{ isset($result->info->format->bit_rate)?$result->info->format->bit_rate:'' }}</label>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="text-start">Number of streams</label>
                                </div>
                                <div class="col-md-6">
                                    <label class="text-end">{{ isset($result->info->format->nb_streams)?$result->info->format->nb_streams:'' }}</label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <label class="text-start">Format</label>
                                </div>
                                <div class="col-md-6">
                                    <label class="text-end">{{ $result->info->format->format_name }}</label>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="text-start">Number of programs</label>
                                </div>
                                <div class="col-md-6">
                                    <label class="text-end">{{ $result->info->format->nb_programs }}</label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <label class="text-start">Full Format Name</label>
                                </div>
                                <div class="col-md-6">
                                    <label class="text-end">{{ $result->info->format->format_long_name }}</label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <label class="text-start">Foramt Match Score</label>
                                </div>
                                <div class="col-md-6">
                                    <label class="text-end">{{ $result->info->format->probe_score }}</label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <label class="text-start">Size</label>
                                </div>
                                <div class="col-md-6">
                                    <label class="text-end">{{ isset($result->info->format->probe_score)?$result->info->format->probe_score:'' }}</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-2"> </div>

                <?php
                
                $streams = $result->info->streams;
                
                ?>
                @foreach ($streams as $index => $list)
                    <div class="col-md-12" style="margin-top: 20px;">
                        <h6 style="color:black;">{{ ucfirst($list->codec_type) }} Stream {{++$index}}</h6>
                        <div class="card shadow">
                            <div class="card-body" style="font-size: 10px;">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Codec Name</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ $list->codec_name }}</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Codec Long Name</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ $list->codec_long_name }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Profile</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->profile)?$list->profile:'' }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Codec Type</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ $list->codec_type }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Codec Tag</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ $list->codec_tag }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Codec Tag String</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ $list->codec_tag_string }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Width</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->width)?$list->width:'' }}px</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Height</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->height)?$list->height:'' }}</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Coded Width</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->coded_width)?$list->coded_width:'' }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Coded Height</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->coded_height)?$list->coded_height:'' }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Closed Captions</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->closed_captions)? $list->closed_captions:'' }}</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Film Grain</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">@if(isset($list->film_grain)) {{ ($list->film_grain==0)?"false":"true" }} @endif </label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">B Frame</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end"> @if(isset($list->has_b_frames))  {{   ($list->has_b_frames==0)?"false":"true" }} @endif</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Sample Aspect Ratio</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">@if(isset($list->sample_aspect_ratio))  {{ $list->sample_aspect_ratio }} @endif</label>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Display Aspect Ratio</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">@if(isset($list->display_aspect_ratio))  {{ $list->display_aspect_ratio }} @endif</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Pixel Format</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{  isset($list->pix_fmt )?$list->pix_fmt :'' }}</label>
                                    </div>
                                </div>



                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Color Range</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->color_range)?$list->color_range:'' }}</label>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Color Space</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->color_space)?$list->color_space:'' }}</label>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Level</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->level)?$list->level:'' }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Chroma Location</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->chroma_location)?$list->chroma_location:'' }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">FPS</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->r_frame_rate)?$list->r_frame_rate:'' }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Time Base</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->time_base)?$list->time_base:'' }}</label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Bit Per Raw Sample</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->bits_per_raw_sample)?$list->bits_per_raw_sample:'' }}</label>
                                    </div>
                                </div>

                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="text-start">Bit Per Raw Sample</label>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="text-end">{{ isset($list->bits_per_raw_sample)?$list->bits_per_raw_sample:'' }}</label>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>


        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
        </div>

    </div>
@endSection
