@extends('layouts.master')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <h5 class="card-header" style="color:black;">Frame Details</h5>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr class="text-nowrap">
                            <th>#</th>
                            <th>Info</th>
                            <th>Photo Frame</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($mainFrames as $index => $list)
                            <tr>
                                <td>{{ ++$index }}</td>
                                <td>


                                    @if (isset($list['info']))
                                        <a style="color: white;" data-bs-toggle="modal"
                                            data-data="{{ json_encode($list['info']) }}" data-bs-target="#modalCenter2"
                                            class="btn btn-primary btn-xs">
                                            View Analytics
                                        </a>
                                    @endif

                                </td>
                                <td>
                                    @isset($list['photo_frame'])
                                        <a download href="data:image/png;base64, {{ $list['photo_frame'] }}">
                                            <img src="data:image/png;base64, {{ $list['photo_frame'] }}"
                                                style="height:100px;" />
                                        </a>
                                    @endisset

                                </td>
                                <td>
                                    @isset($list['camera_id'])
                                        <a href="{{ url('stream/face/detected/') }}/{{ $list['camera_id'] }}/{{ $list['_id'] }}"
                                            class="btn btn-success">View Faces
                                        </a>
                                    @endisset
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="pagination d-flex justify-content-center container">
                @if ($page > 1)
                    <a href="{{ route('stream.frame.detected', ['camera_id' => $camera_id, 'page' => $page - 1]) }}"
                        class="btn btn-secondary btn-sm mx-1">Previous</a>
                @endif

                {{-- Display only "Next" link if not on the last page --}}
                @if ($page < $totalPages)
                    <a href="{{ route('stream.frame.detected', ['camera_id' => $camera_id, 'page' => $page + 1]) }}"
                        class="btn btn-secondary btn-sm mx-1">Next</a>
                @endif
            </div>

        </div>
        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
            {{-- <a href="" class="btn btn-secondary" style="width: 150px;margin-right: 50px;">Back</a> --}}
            {{-- <a href="" class="btn btn-primary" style="width: 150px;">Next</a> --}}
        </div>

        <div class="modal fade" id="modalCenter" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCenterTitle">Frame Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <Img id="img" src="" />
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="modalCenter2" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered  modal-md" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCenterTitle">Frame Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Confidence</th>
                                    </tr>
                                </thead>
                                <tbody id="table-body">
                                    <!-- Data will be inserted here using JavaScript -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <script>
        document.getElementById('modalCenter2').addEventListener('show.bs.modal', (e) => {
            var jsonData = e.relatedTarget.dataset.data;
            //alert("sd");
            console.log(JSON.parse(jsonData));
            populateTable(JSON.parse(jsonData));
        });


        function formatAliasesAndCategories(item) {
            const aliases = item.Aliases.map(alias => alias.Name).join(', ');
            const categories = item.Categories.map(category => category.Name).join(', ');
            return `
            <strong>Aliases:</strong> ${aliases}<br>
            <strong>Categories:</strong> ${categories}
        `;
        }

        // Function to populate the table
        function populateTable(data) {
            const tableBody = document.getElementById('table-body');
            tableBody.innerHTML = '';

            data.forEach(item => {
                const row = document.createElement('tr');
                row.innerHTML = `
                <td>${item.class}</td>
                <td>${item.confidence}%</td>

            `;
                tableBody.appendChild(row);
            });
        }

        // Call the function to populate the table with your JSON data
    </script>
@endSection
