@extends('layouts.app')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <h5 class="card-header" style="color:black;">Frame Details</h5>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <tbody>
                        <tr>
                            <th>Create At</th>
                            <td>{{ App\Helper\HelperData::convertTimeStamp($data['created_at']) }}</td>
                        </tr>
                        <tr>
                            <th>Frame Picture</th>
                            <td>
                                <a style="color: white;" data-bs-toggle="modal" 
                                data-image="{{ $data['frame_photo'] }}"
                                data-bs-target="#modalCenter"
                                    class="btn btn-info btn-xs">
                                    View Frame
                                </a>
                            </td>
                        </tr>

                        <tr>
                            <th>Frame Data</th>
                            <td><a style="color: white;" data-bs-toggle="modal" data-data="{{ json_encode($data['data']) }}"
                                    data-bs-target="#modalCenter2" class="btn btn-primary btn-xs">
                                    View Analytics
                            </a></td>


                        </tr>
                    </tbody>

                    </tbody>
                </table>
            </div>
        </div>
        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
            {{-- <a href="" class="btn btn-secondary" style="width: 150px;margin-right: 50px;">Back</a> --}}
            {{-- <a href="" class="btn btn-primary" style="width: 150px;">Next</a> --}}
        </div>

        <div class="modal fade" id="modalCenter" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCenterTitle">Frame Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <Img id="img" src="" />
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="modalCenter2" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered  modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCenterTitle">Frame Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Confidence</th>
                                        <th>Aliases/Categories</th>
                                    </tr>
                                </thead>
                                <tbody id="table-body">
                                    <!-- Data will be inserted here using JavaScript -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
@section('script_section')
<script>
    document.getElementById('modalCenter').addEventListener('show.bs.modal', (e) => {
        //alert("sd");
        var image = e.relatedTarget.dataset.image;
        document.getElementById("img").src = "data:image/jpg;base64," + image
    });

    document.getElementById('modalCenter2').addEventListener('show.bs.modal', (e) => {
        var jsonData = e.relatedTarget.dataset.data;
        //alert("sd");
        populateTable(JSON.parse(jsonData));
    });


    function formatAliasesAndCategories(item) {
        const aliases = item.Aliases.map(alias => alias.Name).join(', ');
        const categories = item.Categories.map(category => category.Name).join(', ');
        return `
            <strong>Aliases:</strong> ${aliases}<br>
            <strong>Categories:</strong> ${categories}
        `;
    }

    // Function to populate the table
    function populateTable(data) {
        const tableBody = document.getElementById('table-body');
        tableBody.innerHTML = '';

        data.forEach(item => {
            const row = document.createElement('tr');
            row.innerHTML = `
                <td>${item.Name}</td>
                <td>${item.Confidence}%</td>
                <td>${formatAliasesAndCategories(item)}</td>
            `;
            tableBody.appendChild(row);
        });
    }

    // Call the function to populate the table with your JSON data
</script>

@endSection
@endSection
