@extends('layouts.master')
@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="csrf-token2" content="{{ csrf_token() }}">
    <meta name="csrf-token3" content="{{ csrf_token() }}">

    <script src="https://d3js.org/d3.v7.min.js"></script>

    <style>
        .blinking-btn {
    position: relative;
    animation: blink-animation 1.5s infinite;
}

@keyframes blink-animation {
    0% {
        box-shadow: 0 0 10px rgba(255, 193, 7, 0.8), 0 0 20px rgba(255, 193, 7, 0.8), 0 0 30px rgba(255, 193, 7, 0.8);
    }

    50% {
        box-shadow: none;
    }

    100% {
        box-shadow: 0 0 10px rgba(255, 193, 7, 0.8), 0 0 20px rgba(255, 193, 7, 0.8), 0 0 30px rgba(255, 193, 7, 0.8);
    }
}
    </style>

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-lg-8 mb-4 order-0">
                <div class="card">
                    <div class="d-flex align-items-end row">
                        <div class="col-sm-7">
                            <div class="card-body">
                                <h5 class="card-title text-primary">Welcome to CCTV Monitoring Platforms 🎉</h5>
                                <p class="mb-4">
                                    {{-- You have done loaded data at<span class="fw-bold"> 110-10-2023 10:10:00 --}}
                                    To setup your platform please click this button
                                    </span>
                                </p>

                                <a href="{{ route('video-enrichment') }}"
                                    class="btn btn-sm btn-outline-primary blinking-btn">Camera & Region Management</a>


                            </div>
                        </div>
                        <div class="col-sm-5 text-center text-sm-left">
                            <div class="card-body pb-0 px-0 px-md-4">
                                <img src="{{ asset('assets/img/illustrations/man-with-laptop-light.png') }}" height="140"
                                    alt="View Badge User"
                                    data-app-dark-img="{{ asset('illustrations/man-with-laptop-dark.png') }}"
                                    data-app-light-img="{{ asset('illustrations/man-with-laptop-light.png') }}" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 order-1">
                <div class="row">
                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class="avatar flex-shrink-0">
                                        <img src="{{ asset('assets/img/icons/unicons/chart-success.png') }}"
                                            alt="chart success" class="rounded" />
                                    </div>
                                    <div class="dropdown">
                                        <button class="btn p-0" type="button" id="cardOpt3" data-bs-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            <i class="bx bx-dots-vertical-rounded"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="cardOpt3">
                                            <a class="dropdown-item" href="javascript:void(0);">View More</a>
                                        </div>
                                    </div>
                                </div>
                                <span class="fw-semibold d-block mb-1">Total Cameras</span>
                                <h3 class="card-title mb-2" id="total_cameras">{{  $total_camera }}</h3>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class="avatar flex-shrink-0">
                                        <img src="{{ asset('assets/img/icons/unicons/wallet-info.png') }}" alt="Credit Card"
                                            class="rounded" />
                                    </div>
                                    <div class="dropdown">
                                        <button class="btn p-0" type="button" id="cardOpt6" data-bs-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            <i class="bx bx-dots-vertical-rounded"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="cardOpt6">
                                            <a class="dropdown-item" href="javascript:void(0);">View More</a>
                                        </div>
                                    </div>
                                </div>
                                <span>Total Region</span>
                                <h3 class="card-title text-nowrap mb-1" id="active_cameras">{{ $total_regions }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Total Revenue -->
            <div class="col-12 col-lg-8 order-2 order-md-3 order-lg-2 mb-4">
                <div class="row">
                    {{-- <div class="col-6 mb-4">
                        <div class="card">
                            <div class="row row-bordered g-0">
                                <div class="col-md-12">
                                    <h5 class="card-header m-0 me-2 pb-3">Gender Report</h5>
                                    <div id="gender_chart" class="px-2"></div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="col-6 mb-4">
                        <div class="card">
                            <div class="row row-bordered g-0">
                                <div class="col-md-12">
                                    <h5 class="card-header m-0 me-2 pb-3">Age Range Report</h5>
                                    <div id="histogram-chart" class="px-2"></div>
                                </div>

                            </div>
                        </div>
                    </div> --}}
                </div>
            </div>
            <!--/ Total Revenue -->
            <div class="col-12 col-md-8 col-lg-4 order-3 order-md-2">
                <div class="row">
                    {{-- <div class="col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class="avatar flex-shrink-0">
                                        <img src="{{ asset('assets/img/icons/unicons/paypal.png') }}" alt="Credit Card"
                                            class="rounded" />
                                    </div>
                                    <div class="dropdown">
                                        <button class="btn p-0" type="button" id="cardOpt4" data-bs-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            <i class="bx bx-dots-vertical-rounded"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="cardOpt4">
                                            <a class="dropdown-item" href="javascript:void(0);">View More</a>
                                        </div>
                                    </div>
                                </div>
                                <span class="d-block mb-1">Disc-Cameras</span>
                                <h3 class="card-title text-nowrap mb-2" id="dis_cameras">0</h3>

                            </div>
                        </div>
                    </div> --}}
                    {{-- <div class="col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class="avatar flex-shrink-0">
                                        <img src="{{ asset('assets/img/icons/unicons/cc-primary.png') }}"
                                            alt="Credit Card" class="rounded" />
                                    </div>
                                    <div class="dropdown">
                                        <button class="btn p-0" type="button" id="cardOpt1" data-bs-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            <i class="bx bx-dots-vertical-rounded"></i>
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="cardOpt1">
                                            <a class="dropdown-item" href="javascript:void(0);">View More</a>
                                        </div>
                                    </div>
                                </div>
                                <span class="fw-semibold d-block mb-1">Total Regions</span>
                                <h3 class="card-title mb-2" id="total_regions">0</h3>
                            </div>
                        </div>
                    </div> --}}
                    <!-- </div>
                                                                                                                                    <div class="row"> -->
                    {{-- <div class="col-12 mb-4">
                        <div class="card">
                            <div class="card-body" style="height: 171px;">
                                <div class="d-flex justify-content-between flex-sm-row flex-column gap-3">
                                    <div class="d-flex flex-sm-column flex-row align-items-start justify-content-between">
                                        <div class="card-title">
                                            <h5 class="text-nowrap mb-2">Cameras/Regions Report</h5>
                                            <span class="badge bg-label-warning rounded-pill">All</span>
                                        </div>
                                    </div>
                                    <div id="profileReportChart1" style="position: absolute;"> </div>
                                </div>
                            </div>
                        </div>
                    </div> --}}
                </div>
            </div>
        </div>
        <div class="row">
            <!-- Order Statistics -->
            <div class="col-md-12 col-lg-12 col-xl-12 order-0 mb-4">
                <div class="card h-100">
                    <div class="card-header d-flex align-items-center justify-content-between pb-0">
                        <div class="card-title mb-0">
                            <h5 class="m-0 me-2">Regions</h5>
                        </div>
                    </div>
                    <div class="card-body" style="margin-top: 20px;">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <table class="table table-striped table-bordered">
                                <tr>
                                    <th>Region Name</th>
                                    <th>Cameras In Region</th>
                                    <th>Created At</th>
                                </tr>
                                @if ($regionsWithCameraCount)
                                    @foreach ($regionsWithCameraCount as $list)
                                        <tr>
                                            <td>{{ $list['region'] }}</td>
                                            {{--  --}}
                                            <td>{{ $list['camera_count'] }}</td>
                                            <td>{{ \Carbon\Carbon::createFromTimestampMs($list['created_at'])->toDateTimeString() }}</td>

                                        </tr>
                                    @endforeach
                                @endif
                            </table>

                        </div>
                        <div class="card-title mt-20">
                            <h6 class="m-0 me-2" style="text-align: end"><a href="{{ route('regions.all') }}">View All Regions</a></h6>
                        </div>

                    </div>
                </div>
            </div>
            <!--/ Transactions -->
        </div>
    </div>

    {{-- <script>
        window.addEventListener('load', function() {
            loadCamerasReport();

            loadGeneralData();
        })


        function renderReports(allcam, active, dis, regions) {
            const profileReportChartEl = document.querySelector('#profileReportChart1'),
                profileReportChartConfig = {
                    chart: {
                        height: 120,
                        // width: 175,
                        type: 'line',
                        toolbar: {
                            show: false
                        },
                        dropShadow: {
                            enabled: true,
                            top: 10,
                            left: 5,
                            blur: 3,
                            color: config.colors.warning,
                            opacity: 0.15
                        },
                        sparkline: {
                            enabled: true
                        }
                    },
                    grid: {
                        show: false,
                        padding: {
                            right: 8
                        }
                    },
                    colors: [config.colors.warning, config.colors.success, config.colors.danger, config.colors
                        .primary
                    ], // Customize colors as needed
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        width: 5,
                        curve: 'smooth'
                    },
                    series: [{
                            name: 'All Cameras',
                            data: [0, allcam] // Replace with your camera data
                        },
                        {
                            name: 'Active Cameras',
                            data: [0, active] // Replace with data for another camera
                        },
                        {
                            name: 'Disconnected Cameras',
                            data: [0, dis] // Replace with data for a region
                        },
                        {
                            name: 'Regions',
                            data: [0, regions] // Replace with data for a region
                        },
                        // Add more series for other regions as needed
                    ],
                    xaxis: {
                        show: false,
                        lines: {
                            show: false
                        },
                        labels: {
                            show: false
                        },
                        axisBorder: {
                            show: false
                        }
                    },
                    yaxis: {
                        show: false
                    }
                };


            const profileReportChart = new ApexCharts(profileReportChartEl, profileReportChartConfig);
            profileReportChart.render();
        }

        function loadCamerasReport() {


            // Get the CSRF token value from the meta tag
            var csrfToken = $('meta[name="csrf-token"]').attr('content');
            // Your AJAX POST request
            $.ajax({
                type: 'POST',
                url: '{{ route('cameras.all') }}', // Replace with your actual route URL
                data: {
                    _token: csrfToken, // Include the CSRF token in the request
                    // Other data to send
                },
                success: function(data) {
                    if (data) {
                        allcameras = document.getElementById("total_cameras");
                        active_cameras = document.getElementById("active_cameras");
                        total_regions = document.getElementById("total_regions");
                        dis_cameras = document.getElementById("dis_cameras");
                        allcameras.innerHTML = data.allcameras
                        active_cameras.innerHTML = data.activeCameras
                        dis_cameras.innerHTML = data.disconnectedCameras
                        total_regions.innerHTML = data.total_regions
                        renderReports(data.allcameras, data.activeCameras, data.disconnectedCameras, data
                            .total_regions)
                        //console.log(data.allcameras);
                    }
                },
                error: function(xhr, textStatus, errorThrown) {
                    // Handle errors here
                }
            });
        }

        function loadGeneralData() {

            // Get the CSRF token value from the meta tag
            var csrfToken = $('meta[name="csrf-token"]').attr('content');
            // Your AJAX POST request
            $.ajax({
                type: 'POST',
                url: '{{ route('general.data') }}', // Replace with your actual route URL
                data: {
                    _token: csrfToken, // Include the CSRF token in the request
                    // Other data to send
                },
                success: function(data) {
                    if (data) {
                        loadGender(data.data)
                        loadAgeRange(data.age)
                        console.log(data.data);
                    }
                },
                error: function(xhr, textStatus, errorThrown) {
                    // Handle errors here
                }
            });
        }

        function loadGender(data) {
            // Create a data map for counting occurrences of each gender
            const dataMap = d3.rollup(data, v => v.length, d => d);

            // Convert data map to an array of objects
            const dataArray = Array.from(dataMap, ([gender, count]) => ({
                gender,
                count
            }));

            // Create SVG container
            const svg = d3.select("#gender_chart").append("svg").attr("width", 300).attr("height", 300);

            // Create scales
            const xScale = d3.scaleBand().domain(dataArray.map(d => d.gender)).range([50, 350]).padding(0.1);
            const yScale = d3.scaleLinear().domain([0, d3.max(dataArray, d => d.count)]).nice().range([250, 50]);

            // Create bars
            svg.selectAll("rect")
                .data(dataArray)
                .enter().append("rect")
                .attr("x", d => xScale(d.gender))
                .attr("y", d => yScale(d.count))
                .attr("width", xScale.bandwidth())
                .attr("height", d => 250 - yScale(d.count))
                .attr("fill", "steelblue");

            // Create x-axis
            svg.append("g")
                .attr("transform", `translate(0, ${250})`)
                .call(d3.axisBottom(xScale));

            // Create y-axis
            svg.append("g")
                .attr("transform", `translate(50, 0)`)
                .call(d3.axisLeft(yScale));
        }

        function loadAgeRange(ageData) {
            // Create an array of age range values
            // Sample age data (replace with your data)
            //   const ageData = [ /* Your age data here */ ];

            // Extract "Low" and "High" values and flatten them into a single array
            const ageValues = ageData.map(entry => [entry.Low, entry.High]).flat();

            // Define the histogram parameters
            const margin = {
                top: 20,
                right: 30,
                bottom: 30,
                left: 40
            };
            const width = 600 - margin.left - margin.right;
            const height = 300 - margin.top - margin.bottom;

            // Create an SVG container for the chart
            const svg = d3.select("#histogram-chart")
                .append("svg")
                .attr("width", width + margin.left + margin.right)
                .attr("height", height + margin.top + margin.bottom)
                .append("g")
                .attr("transform", `translate(${margin.left},${margin.top})`);

            // Set the number of bins and the range of ages
            const numBins = 10;
            const ageRange = [0, 100]; // Modify the range based on your data

            // Create a histogram function
            const histogram = d3.histogram()
                .domain(ageRange)
                .thresholds(d3.range(ageRange[0], ageRange[1], (ageRange[1] - ageRange[0]) / numBins));

            // Compute the histogram bins
            const bins = histogram(ageValues);

            // Define a color scale for the bins
            const colorScale = d3.scaleSequential(d3.interpolateBlues)
                .domain([0, d3.max(bins, d => d.length)]);

            // Define x and y scales
            const x = d3.scaleLinear()
                .domain([ageRange[0], ageRange[1]])
                .range([0, width]);

            const y = d3.scaleLinear()
                .domain([0, d3.max(bins, d => d.length)])
                .nice()
                .range([height, 0]);

            // Create and style the histogram bars
            svg.selectAll("rect")
                .data(bins)
                .enter()
                .append("rect")
                .attr("x", d => x(d.x0))
                .attr("y", d => y(d.length))
                .attr("width", d => x(d.x1) - x(d.x0))
                .attr("height", d => height - y(d.length))
                .attr("fill", d => colorScale(d.length));
            // Define scales for x and y axes

            // Create x and y axes
            const xAxis = d3.axisBottom(x);
            const yAxis = d3.axisLeft(y);

            // Append the x and y axes to the chart
            svg.append("g")
                .attr("class", "x-axis")
                .attr("transform", `translate(0,${height})`)
                .call(xAxis);

            svg.append("g")
                .attr("class", "y-axis")
                .call(yAxis);
        }
    </script> --}}
@endSection
