@extends('layouts.master')

@section('content')
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <h3 class="mb-4">Update Project</h3>

        <div class="bg-light rounded h-100 p-4">
            <form method="POST" action="{{ route('project.update') }}">
                @csrf
                <input type="hidden"  value="{{$project->id}}" name="id"  />
                <div class="row">
                    <div class="col-sm-12 col-xl-5">
                        <h6 class="mb-4">Add Project</h6>

                        <div class="mb-3">
                            <label for="name" class="col-md-4 col-form-label">Project name</label>

                            <div class="col-md-12">
                                <input id="name"
                                  value="{{$project->project_name}}"
                                type="text" class="form-control @error('name') is-invalid @enderror" name="name" required autocomplete="name" autofocus>

                                @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>

                        <div class=" mb-3">
                            <label for="icon" class="col-md-4 col-form-label ">Project Icon</label>

                            <div class="col-md-12">
                                <input id="icon" type="text" 
                                class="form-control @error('icon') is-invalid @enderror" 
                                name="icon"  value="{{$project->icon}}" required autocomplete="icon">

                                @error('icon')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>

                        <div class=" mb-3">
                            <label for="icon" class="col-md-4 col-form-label ">Project URL</label>

                            <div class="col-md-12">
                                <input id="url" type="url"
                                 class="form-control @error('url') is-invalid @enderror" 
                                 name="url"  value="{{$project->project_url}}" required autocomplete="icon">

                                @error('icon')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>


                        <div class=" mb-3">
                            <label for="icon" class="col-md-4 col-form-label ">Short Message</label>
                            <div class="col-md-12">
                                <input id="msg" type="text" class="form-control @error('msg') is-invalid @enderror" 
                                name="msg"  value="{{$project->short_details}}" autocomplete="icon">

                            </div>
                        </div>
                        <div class="row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </div>

                </div>
            </form>
        </div>



    </div>
</div>
@endsection