@extends('layouts.master')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="bg-light rounded h-100 p-4">
                <table class="table table-striped">
                    <tr>
                        <th>Project Name</th>
                        <th>Project Icon</th>
                        <th>Project URL</th>
                        <th>Short Details</th>
                        <th>Action</th>
                    </tr>
                    @if($projects)
                    @foreach($projects as $p)
                      <tr>
                        <td>{{$p->project_name}}</td>
                        <td>{{$p->icon}}</td>
                        <td>{{$p->project_url}}</td>
                        <td>{{$p->short_details}}</td>
                        <td>
                            <a class="btn btn-sm btn-primary"
                            href="{{ route('project.edit', $p->id) }}">Edit</a>

                        <button class="btn btn-sm btn-danger"
                            onclick="deleteProject('{{$p->id}}')">Delete</button>

                        </td>
                      </tr>
                    @endforeach
                    @endif
                </table>
            </div>
        </div>
    </div>

    @section('custom')
    <script>
        function deleteProject(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                window.location.href = "{{ url('delete/project') }}/" + id;
            })
        }
    </script>
@endsection
@endsection
