@extends('layouts.master')
@section('content')

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        .image-upload>input {
            display: none;
        }

        .upload-icon {
            width: 100px;
            height: 97px;
            border: 2px solid #5642BE;
            border-style: dotted;
            border-radius: 18px;
        }

        .upload-icon img {
            width: 60px;
            height: 60px;
            margin: 19px;
            cursor: pointer;
        }

        .upload-icon.has-img {
            width: 100px;
            height: 97px;
            border: none;
        }

        .upload-icon.has-img img {
            width: 100%;
            height: auto;
            border-radius: 18px;
            margin: 0px;
        }
    </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card">
            <h5 class="card-header" style="color:black;">Search Data</h5>
            <div class="row" style="display: block;text-align: end;">
                <button class="btn btn-primary" type="button" onclick="showHideLayout()"
                    style="margin-right: 34px;width: auto;font-size: 10px;padding: 6px;margin-bottom: 18px;"><i
                        class="menu-icon tf-icons bx bx-filter"></i>More Attribures</button>
            </div>
            <form id="yourForm" enctype="multipart/form-data">
                <div class="row" method="POST" style="margin-left: 13px; margin-right: 13px; margin-bottom:10px; ">
                    @csrf

                    <div class="col-md-2">
                        <div class="form-group ">
                            <label>Start Age</label>
                            <input style="font-size: 10px;" name="start_age" type="number" class="form-control" />
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>End Age</label>
                            <input style="font-size: 10px;" name="end_age" type="number" class="form-control" />
                        </div>
                    </div>


                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Gender</label>
                            <select style="font-size: 10px;" class="form-control" id="gender" name="gender">
                                <option></option>
                                <option style="color: black;font-size: 15px; ">Male</option>
                                <option style="color: black;font-size: 15px">Female</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Start Time</label>
                            <input style="font-size: 10px;" type="date" required class="form-control"
                                id="_date" name="datetime" />
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>End Time</label>
                            <input style="font-size: 10px;" type="date" required class="form-control"
                                id="end_date" name="end_datetime" />
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="image-upload">
                            <label for="file-input">
                                <div class="upload-icon" style="background-repeat: no-repeat;height: 150px;background-size: cover;width:150px;background-position: center;background-image: url('https://cdn.pixabay.com/photo/2017/11/10/05/24/select-2935439_1280.png');">
                                    <img class="icon"
                                        style="margin-top: 47px;margin-left: 50px;height: min-content;width: min-content;border-radius: 19px;"
                                        >
                                </div>
                            </label>
                            <input id="file-input" type="file" name="face_img" />
                        </div>
                    </div>
                </div>

                <div id="attr_layout" style="display: none;">
                    <div class="row"
                        style="padding: 11px;background: #c2c2c2;margin-left: 13px;margin-right: 13px;border-radius: 10px;">
                        <div class="col-md-2">
                            <div class="form-group form-control">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                    <label class="form-check-label" for="flexCheckDefault">
                                        Eyeglasses
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group form-control">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                    <label class="form-check-label" for="flexCheckDefault">
                                        Sunglasses
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group form-control">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                    <label class="form-check-label" for="flexCheckDefault">
                                        Beard
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-primary " type="button" onclick="addTextField()"
                                style="padding: 6px;width: auto;font-size: 11px;">Add Attribues</button>
                        </div>
                        <div class="row">

                            <div id="textFieldContainer" style=" margin-top: 43px; ">

                            </div>

                        </div>
                    </div>
                </div>
                <div class="row" style="display: none;text-align: center;" id="animation_">
                    <script src="https://unpkg.com/@dotlottie/player-component@latest/dist/dotlottie-player.mjs" type="module"></script>
                    <dotlottie-player src="https://lottie.host/d092d495-6255-4e9d-a4bf-260a8d254dd7/APrN4NPPUP.json"
                        background="#000000" speed="1"
                        style="width: 150px; height: 150px;text-align: center;
                        display: inline-block;"
                        direction="1" mode="normal" loop autoplay></dotlottie-player>
                </div>

                <div class="row" style=" text-align: center; display: block; margin-top: 10px; margin-bottom: 20px; ">
                    <button class="btn btn-primary" type="submit"
                        style="padding: 6px;width: auto;font-size: 11px;">Search</button>
                </div>
            </form>
        </div>

        <div class="card" style="margin-top:20px;">
            <div class="row" style="padding: 20px;">
                <div class="col-md-12">
                    <h5>Face Matching Base Result</h5>
                    <table class="table table-striped" id="imageTableBody">
                        <tr>
                            <td>Face Image</td>
                            <td>Created At</td>
                            <td>Action</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

 
        {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/vue/2.6.14/vue.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/socket.io/4.1.2/socket.io.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/laravel-echo/1.11.3/echo.min.js"></script>
        <script src="https://js.pusher.com/7.0/pusher.min.js"></script> --}}
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>

        <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>
        <script src="{{ asset('moment.js') }}"></script>

        <script>
            $(document).ready(function() {
            
                $('#yourForm').on('submit', function(e) {
                    e.preventDefault();
                    // Get form values

                    const gender = document.getElementById('gender').value;
                    const date = document.getElementById('_date').value;
                    const end_datetime = document.getElementById('end_date').value;
                    const faceImg = document.getElementById('file-input').value;

                    // Check if all fields are empty
                    if (end_datetime === '' && date === '') {
                        // Alert the user or perform any action indicating that the fields are empty
                        Swal.fire({
                            title: "Missing Fields",
                            text: "Start and end datetime field are required",
                            icon: "warning"
                        });
                        return;
                    }

                    // Get form data
                    var formData = new FormData(this);
                    formData.append('file', $('#file-input')[0].files[0]); // Append the file to FormData

                    // Send an AJAX request
                    $.ajax({
                        url: "{{ route('data.find.search') }}",
                        method: 'POST',
                        data: formData,
                        processData: false,
                        contentType: false,

                        headers: {
                            'X-CSRF-TOKEN': getCSRFToken() // Include CSRF token in headers
                        },

                        beforeSend: function() {
                            clearTableRows()
                            // Actions to perform before sending the request
                            console.log('Preparing to send the request...');
                            $("#animation_").attr("style", "display:block;text-align:center;")
                            // You can show a loader, disable buttons, or set up something else
                        },
                        success: function(response) {
                            console.log(response);
                            // Handle the response from the server
                            resp = JSON.parse(response);
                            if (resp.status == 204) {
                                Swal.fire({
                                    title: "Missing Fields",
                                    text: resp.message,
                                    icon: "warning"
                                });
                            }
                            $("#animation_").attr("style", "display:none;text-align:center;")
                        },
                        error: function(xhr, status, error) {
                            // Handle errors
                            console.error(error);
                            $("#animation_").attr("style", "display:none;text-align:center;")

                        }
                    });
                });
            });

            $('#file-input').change(function(event) {
                $("img.icon").attr('src', URL.createObjectURL(event.target.files[0]));
                $("img.icon").parents('.upload-icon').addClass('has-img');
            });

            // Enable pusher logging - don't include this in production
            Pusher.logToConsole = true;
            var pusher = new Pusher(
                '{{ env('PUSHER_APP_KEY') }}', {
                    cluster: '{{ env('PUSHER_APP_CLUSTER') }}'
                });

            var channel = pusher.subscribe('my-channel');

            channel.bind('my-event', function(data) {
               // var msgg = data['message'];
                if (data['status'] == 200) {
                    get_details(data['id']);
                } else {
                    $("#animation_").attr("style", "display:none;text-align:center;")
                }
                //alert(JSON.stringify(data));
            });

            function getCSRFToken() {
                return $('meta[name="csrf-token"]').attr('content');
            }


            function get_details(id) {
                var tableBody = document.getElementById('imageTableBody');
                $.ajax({
                    url: "{{ url('search/face') }}/" + id,
                    method: 'GET',
                    headers: {
                        'X-CSRF-TOKEN': getCSRFToken() // Include CSRF token in headers
                    },
                    beforeSend: function() {},
                    success: function(response) {
                        resp = JSON.parse(response)
                        if (resp.status == 200) {
                            console.log(resp.created_at);
                            result = resp.id
                            console.log(result);
                            frameImageData = resp.face_image
                            // // Create a new table row
                            var newRow = tableBody.insertRow();

                            // Create cell for frame image created_at
                            var frameImageCell = newRow.insertCell();
                            var frameImage = document.createElement('img');
                            frameImage.src = "data:image/jpg;base64," +
                                frameImageData; // Set the source of the image to the base64 data
                            frameImageCell.appendChild(frameImage);


                            var faceImageCell1 = newRow.insertCell();
                            // Convert Unix timestamp to Date object
                            // var timestamp = resp.created_at.$date.$numberLong;
                            //console.log(moment.unix(timestamp).format('YYYY-MM-DD HH:mm:ss'));
                            var textNode2 = document.createTextNode(resp.created_at);
                            faceImageCell1.appendChild(textNode2);


                            var faceImageCell2 = newRow.insertCell();
                            var anchorTag = document.createElement('a');
                            anchorTag.setAttribute('href', '{{ url('frame/faces') }}/' + result
                                .$oid); // Set href attribute
                            anchorTag.setAttribute('class', 'btn btn-primary'); // Set class attribute
                            anchorTag.setAttribute('style', 'padding: 4px;font-size: 12px'); // Set class attribute
                            anchorTag.setAttribute('target', '_blank'); // Set class attribute
                            anchorTag.textContent = 'View Details'; // Set link text

                            // Append the anchor tag to the cell
                            faceImageCell2.appendChild(anchorTag);
                        }
                        // Create cell for face image
                    },
                    error: function(xhr, status, error) {
                        // Handle errors
                        console.error(error);
                    }
                });
            }


            function clearTableRows() {
                const tableBody = document.getElementById('imageTableBody');
                // Remove all child nodes (rows) from the table body
                while (tableBody.firstChild) {
                    tableBody.removeChild(tableBody.firstChild);
                }

                var newRow = tableBody.insertRow();
                var faceImageCell1 = newRow.insertCell();
                var textNode2 = document.createTextNode("Face Image");
                faceImageCell1.appendChild(textNode2);

                var faceImageCell2 = newRow.insertCell();
                var textNode2 = document.createTextNode("Created At");
                faceImageCell2.appendChild(textNode2);

                var faceImageCell3 = newRow.insertCell();
                var textNode3 = document.createTextNode("Action");
                faceImageCell3.appendChild(textNode3);
            }

            function addTextField() {
                const container = document.getElementById("textFieldContainer");

                // Create a Bootstrap form group
                const formGroup = document.createElement("div");
                formGroup.classList.add("form-group", "col-md-4");

                // Create a new text input element
                const input = document.createElement("input");
                input.type = "text";
                input.classList.add("form-control");
                input.name = "dynamicField[]"; // Use an array if you plan to handle multiple fields
                input.placeholder = "Enter attibutes";

                // Create a button for removal
                const removeButton = document.createElement("button");
                removeButton.textContent = "Remove";
                removeButton.classList.add("btn", "btn-danger", "mt-2");
                removeButton.setAttribute("style", "font-size:10px;margin-bottom:10px;")
                //    removeButton.classList.attr("style", "padding: 6px;width: auto;font-size: 11px;", "mt-2");
                removeButton.onclick = function() {
                    container.removeChild(formGroup);
                };

                // Append input and remove button to the form group
                formGroup.appendChild(input);
                formGroup.appendChild(removeButton);

                // Append form group to the container
                container.appendChild(formGroup);
            }

            function showHideLayout() {
                const container = document.getElementById("attr_layout");
                if (container.style.display === "block") {
                    container.style.display = "none"; // Hide the container
                } else {
                    container.style.display = "block"; // Show the container
                }
            }
        </script>
@endSection