@extends('layouts.master')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Cameras List</h4>
            </div>
            </a>
            <div class="card-body">

                <div class="table-responsive text-nowrap">
                    <table class="display" id="example2" style="width:100%">
                        <thead>
                            <tr class="text-nowrap">
                                <th>#</th>
                                <th>Camera Name</th>
                                <th>Streaming URl</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($cameras)
                                @foreach ($cameras as $index => $list)
                                    <tr>
                                        <th scope="row">{{ ++$index }}</th>
                                        <td>{{ $list['cameraname'] }}</td>
                                        <td>{{ $list['stream_url'] }}</td>
                                        <td>
                                            @if ($list['status'] == 1)
                                                <span class="badge bg-success ">Active</span>
                                            @else
                                                <span class="badge bg-danger badge-sm">Disconnected</span>
                                            @endif
                                        </td>

                                        <td><a href="{{ route('camera.details', $list['_id']) }}"
                                                class="btn btn-primary  btn-sm">Open Camera</a>


                                            {{-- <a href="{{ route('camera.find', $list['_id']) }}" class="btn btn-info  btn-sm">Edit
                                        </a>


                                        <a href="javacsript::void(0)" onclick="deleteCamera('{{$list['_id']}}')"
                                            class="btn btn-danger  btn-sm">Delete </a> --}}
                                        </td>
                                    </tr>
                                @endforeach
                            @endif

                        </tbody>
                    </table>
                </div>

            </div>
        </div>


        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
            {{-- <a href="" class="btn btn-secondary" style="width: 150px;margin-right: 50px;">Back</a> --}}
            {{-- <a href="" class="btn btn-primary" style="width: 150px;">Next</a> --}}
        </div>


    </div>
    </div>
    </div>


    <script>
        function deleteCamera(id) {
            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('delete/camera/') }}/" + id;
                }
            });
        }
    </script>


@endSection
