@extends('layouts.master')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <h5 class="card-header" style="color:black;"> Face Detection List</h5>
            <div class="table-responsive text-nowrap">
                <table class="table" style=" font-size: 10px; ">
                    <thead>
                        <tr class="text-nowrap">
                            <th>#</th>
                            <th>View</th>
                            <th>Age Range</th>
                            <th>Gender</th>
                            <th>Created At</th>
                            <th>Emotions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if ($result)
                            @foreach ($result as $index => $list)
                                <?php
                                $faceDetails = $list['face_details'];
                                ?>

                                <tr>
                                    <th scope="row">{{ ++$index }}</th>

                                    <td><a style="color: white;" target="_blank"
                                            href="{{ url('frame/faces/', []) }}/{{ $list['_id'] }}"
                                            class="btn btn-info btn-sm">
                                            View Frame
                                        </a>

                                   <a style="color: white;"target="_blank"
                                            href="{{ url('frame/faces/', []) }}/{{ $list['_id'] }}"
                                            class="btn btn-primary btn-sm">
                                            View Face
                                        </a></td>

                                    <td>
                                        <?php
                                          $AgeRange = $faceDetails['AgeRange'];
                                          echo $AgeRange['Low'] . '-' . $AgeRange['High'];
                                        ?>
                                    </td>

                                    <td>
                                        <?php
                                         $Gender = $faceDetails['Gender'];
                                         echo '<b style="color:black">' . $Gender['Value'] . '</b>' . '=>' . (int) $Gender['Confidence'] . '%';
                                        ?>
                                    </td>
                                    <td>{{ App\Helper\HelperData::convertTimeStamp($list['created_at']) }}</td>

                                    <td>
                                        <?php
                                        $Emotions = $faceDetails['Emotions'];
                                        foreach ($Emotions as $em) {
                                            if ($em['Type'] == 'HAPPY' || $em['Type'] == 'SAD') {
                                                echo '<b style="color:black">' . $em['Type'] . '</b>' . '=>' . (int) $em['Confidence'] . '%' . '<br>';
                                            }
                                        }
                                        ?>
                                    </td>


                                </tr>
                            @endforeach
                        @endif

                    </tbody>
                </table>
            </div>
        </div>
        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
            {{-- <a href="" class="btn btn-secondary" style="width: 150px;margin-right: 50px;">Back</a> --}}
            {{-- <a href="" class="btn btn-primary" style="width: 150px;">Next</a> --}}
        </div>

        <div class="modal fade" id="modalCenter" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCenterTitle">Frame Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <Img id="img" src="" style="width: auto;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="modalCenter2" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered  modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCenterTitle">Frame Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Confidence</th>
                                        <th>Aliases/Categories</th>
                                    </tr>
                                </thead>
                                <tbody id="table-body">
                                    <!-- Data will be inserted here using JavaScript -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>


@section('script_section')
    <script>
        document.getElementById('modalCenter').addEventListener('show.bs.modal', (e) => {
            //alert("sd");
            var image = e.relatedTarget.dataset.image;
            document.getElementById("img").src = "data:image/jpg;base64," + image
        });

        document.getElementById('modalCenter2').addEventListener('show.bs.modal', (e) => {
            var jsonData = e.relatedTarget.dataset.data;
            //alert("sd");
            populateTable(JSON.parse(jsonData));
        });


        function formatAliasesAndCategories(item) {
            const aliases = item.Aliases.map(alias => alias.Name).join(', ');
            const categories = item.Categories.map(category => category.Name).join(', ');
            return `
                <strong>Aliases:</strong> ${aliases}<br>
                <strong>Categories:</strong> ${categories}
            `;
        }

        // Function to populate the table
        function populateTable(data) {
            const tableBody = document.getElementById('table-body');
            tableBody.innerHTML = '';

            data.forEach(item => {
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${item.Name}</td>
                    <td>${item.Confidence}%</td>
                    <td>${formatAliasesAndCategories(item)}</td>
                `;
                tableBody.appendChild(row);
            });
        }

        

        // Call the function to populate the table with your JSON data
    </script>
@endSection
@endSection
