@extends('layouts.master')
@section('content')

    <style>
        .btn-borderless {
            background: transparent;
            border: 0px;
        }

        .text-start {
            font-weight: bold;
        }

        .circle {
            display: inline-block;
            width: 20px;
            height: 20px;
            margin: 0 5px;
            border-radius: 50%;
            cursor: pointer;
        }

        @keyframes glow {

            0%,
            100% {
                box-shadow: 0 0 2px 0px currentColor;
            }

            50% {
                box-shadow: 0 0 10px 5px currentColor;
            }
        }

        .red {
            background-color: #f00;
            color: #f00;
            /* animation: glow 1s ease-in-out infinite; */
        }

        .yellow {
            background-color: #ff0;
            color: #ff0;
            /* animation: glow 1s ease-in-out infinite; */
        }

        .green {
            background-color: #0f0;
            color: #0f0;
            /* animation: glow 1s ease-in-out infinite; */
        }


        #myList li {
            color: white;
            font-size: 16px
        }

        #myList2 li {
            color: white;
            font-size: 16px
        }

        .blinking-text {
            animation: blink 1s infinite;
            text-shadow: 0 0 10px #fff;
            /* add a white shadow */
        }

        .yellow-shadow {
            box-shadow: 0 0 5px 2px yellow;
        }

        .red-shadow {
            box-shadow: 0 0 5px 2px red;
        }

        .highlight-border {
            box-shadow: 0 0 20px rgba(255, 255, 0, 0.8),
                /* More intense Yellow */
                0 0 25px rgba(0, 255, 0, 0.8),
                /* More intense Green */
                0 0 25px rgba(255, 0, 0, 0.8);
            /* More intense Red */
            border-radius: 8px;
            /* Rounded corners */
            background-color: transparent;
            /* No background color */
            padding: 5px;
            /* Optional padding */
            transition: box-shadow 0.3s ease;
            /* Smooth transition for hover effect */
        }

        .highlight-border:hover {
            box-shadow: 0 0 30px rgba(255, 255, 0, 1),
                /* Very strong Yellow */
                0 0 30px rgba(0, 255, 0, 1),
                /* Very strong Green */
                0 0 30px rgba(255, 0, 0, 1);
            /* Very strong Red */
        }








        @keyframes blink {
            0% {
                opacity: 1;
            }

            50% {
                opacity: 0;
            }

            100% {
                opacity: 1;
            }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Monitor Stream</h4>
            </div>

            <div class="card-body" id="top_layout" style="display: none;">
                <div class="table-responsive">
                    <table class="display table " style="width:100%">
                        <thead>
                            <tr class="text-nowrap">
                                <th>#</th>
                                <th>Camera Name</th>
                                <th>Region Name</th>
                                <th>Server Status</th>
                                <th>Streaming Status</th>
                                <th>Alarm Status</th>
                                <th>Monitoring</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>1</td>
                                <td>{{ $cameraname }}</td>
                                <td>{{ $region_name }}</td>
                                <td id="col_id">Running</td>
                                <td id="col_id">
                                    {{ isset($steaming_info->info) ? 'Running' : 'In Progress' }}
                                    {{-- @if (isset($steaming_info->info))
                                        Running
                                    @else
                                        In Progress
                                    @endif --}}
                                </td>

                                <td>
                                    <div class="container-alaram-status">

                                        <div class="circle red" id="p1-alarm-staus"
                                            onclick="change_layout(1); toggleHighlightTable('p1-alarms-table')">
                                        </div>
                                        <div class="circle yellow" id="p2-alarm-staus"
                                            onclick="toggleHighlightTable('p2-alarms-table')"></div>
                                        <div class="circle green"></div>
                                    </div>

                                </td>
                                <td>

                                    <a role="button" href="{{ url('virtial-wall/view') }}" class="btn-borderless">
                                        <span class="badge badge-circle badge-dark light text-primary">Virtual Wall</i>
                                        </span>
                                    </a>

                                </td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>State</th>
                                <th>Status checks</th>
                                <th>Alarm Status</th>
                                <th>Monitoring</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                {{-- tabs --}}
                <!-- Nav tabs -->
                <div class="card p-3 mt-5" id="dark-card1">
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item active">
                                <a class="nav-link active" data-bs-toggle="tab" href="#tab_4"><i
                                        class="bi bi-info-circle-fill me-2"></i>
                                    Alarms</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#tab_1"><i class="bi bi-card-text me-2"></i>
                                    Camera Stream Details</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#tab_2"><i class="bi bi-bar-chart me-2"></i>
                                    Bitrate</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#tab_3"><i class="bi bi-display me-2"></i>
                                    Stream Monitoring</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#tab_5"><i
                                        class="bi bi-chat-left-text-fill me-2"></i>
                                    Custom Alarms Configration</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade" id="tab_1" role="tabpanel">
                                <div class="row" style="margin-top: 20px;" id="tab_1_steaming_info">
                                    @if (isset($steaming_info->info) && $steaming_info->info->format->filename != '')
                                        <div class="col-md-12">

                                            <div class="row">
                                                <div class="col-md-3">
                                                    <label class="text-start">URL OR IP
                                                        Address</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <label
                                                        class="text-end">{{ $steaming_info->info->format->filename }}</label>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-3">
                                                    <label class="text-start">Number of streams</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <label
                                                        class="text-end">{{ isset($steaming_info->info->format->nb_streams) ? $steaming_info->info->format->nb_streams : '' }}</label>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-3">
                                                    <label class="text-start">Streams format</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <label
                                                        class="text-end">{{ $steaming_info->info->format->format_name }}</label>
                                                </div>
                                            </div>


                                            <div class="row">
                                                <div class="col-md-3">
                                                    <label class="text-start">Full Format Name</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <label
                                                        class="text-end">{{ $steaming_info->info->format->format_long_name }}</label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <label class="text-start">File Size</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <label class="text-end">
                                                        @if (isset($steaming_info->info->format->size))
                                                            {{ App\Helper\HelperData::humanReadableFileSize($steaming_info->info->format->size) }}
                                                        @endif

                                                    </label>
                                                </div>
                                            </div>

                                            <?php
                                            $streams = $steaming_info->info->streams;
                                            ?>

                                            @foreach ($streams as $index => $list)
                                                <div class="col-md-12" style="margin-top: 20px;">
                                                    <h6 style="color:black;">{{ ucfirst($list->codec_type) }} Stream
                                                        {{ ++$index }}</h6>
                                                    <div class="card shadow">
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Codec Name</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label class="text-end">{{ $list->codec_name }}</label>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Codec Long Name</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ $list->codec_long_name }}</label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Profile</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->profile) ? $list->profile : '' }}</label>
                                                                </div>
                                                            </div>


                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Aspect Ratio</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->display_aspect_ratio) ? $list->display_aspect_ratio : '' }}</label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Codec Type</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ $list->codec_type }}</label>
                                                                </div>
                                                            </div>


                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Width</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->width) ? $list->width : '' }}px</label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Height</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->height) ? $list->height : '' }}</label>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Coded Width</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->coded_width) ? $list->coded_width : '' }}</label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Coded Height</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->coded_height) ? $list->coded_height : '' }}</label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Closed Captions</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->closed_captions) ? $list->closed_captions : '' }}</label>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Film Grain</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label class="text-end">
                                                                        @if (isset($list->film_grain))
                                                                            {{ $list->film_grain == 0 ? 'false' : 'true' }}
                                                                        @endif
                                                                    </label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">B Frame</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label class="text-end">
                                                                        @if (isset($list->has_b_frames))
                                                                            {{ $list->has_b_frames == 0 ? 'false' : 'true' }}
                                                                        @endif
                                                                    </label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Sample Aspect Ratio</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label class="text-end">
                                                                        @if (isset($list->sample_aspect_ratio))
                                                                            {{ $list->sample_aspect_ratio }}
                                                                        @endif
                                                                    </label>
                                                                </div>
                                                            </div>


                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Display Aspect Ratio</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label class="text-end">
                                                                        @if (isset($list->display_aspect_ratio))
                                                                            {{ $list->display_aspect_ratio }}
                                                                        @endif
                                                                    </label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Pixel Format</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->pix_fmt) ? $list->pix_fmt : '' }}</label>
                                                                </div>
                                                            </div>



                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Color Range</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->color_range) ? $list->color_range : '' }}</label>
                                                                </div>
                                                            </div>


                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Color Space</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->color_space) ? $list->color_space : '' }}</label>
                                                                </div>
                                                            </div>


                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Level</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->level) ? $list->level : '' }}</label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Chroma Location</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->chroma_location) ? $list->chroma_location : '' }}</label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">FPS</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->r_frame_rate) ? $list->r_frame_rate : '' }}</label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Time Base</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->time_base) ? $list->time_base : '' }}</label>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Bit Per Raw Sample</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->bits_per_raw_sample) ? $list->bits_per_raw_sample : '' }}</label>
                                                                </div>
                                                            </div>


                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="text-start">Bit Per Raw Sample</label>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <label
                                                                        class="text-end">{{ isset($list->bits_per_raw_sample) ? $list->bits_per_raw_sample : '' }}</label>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach

                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="tab-pane fade" id="tab_2">
                                <div class="row" style="margin-top: 20px;">
                                    <div class="col-md-12">

                                        <div class="row">
                                            <div class="col-md-6">
                                                <label class="text-start">Bit Rate</label>
                                            </div>
                                            <div class="col-md-6">
                                                <label
                                                    class="text-end">{{ isset($steaming_info->info->format->bit_rate) ? $steaming_info->info->format->bit_rate : '' }}
                                                    bps</label>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label class="text-start">Latency Second</label>
                                            </div>
                                            <div class="col-md-6">
                                                <label
                                                    class="text-end">{{ isset($steaming_info->info->latency_seconds) ? $steaming_info->info->latency_seconds : '' }}
                                                    ms</label>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="tab_3">
                                {{-- {{ $result['stream_url'] }} --}}
                                <div class="pt-4" id="show_media_tab_3">



                                </div>
                            </div>
                            <div class="tab-pane fade show active" id="tab_4">
                                <div class="card p-3 mt-5" id="dark-card1" style="margin: 10px;">

                                    {{-- show camera logs --}}
                                    <ul id="myList" style="font-size: 16px; list-style-type: square; padding: 10px;">
                                    </ul>

                                    <div class="d-flex justify-content-evenly">
                                        <!-- P1 Alarms Table -->
                                        <div class="table-responsive p1-table p1-alarms-table">
                                            <table class="display table" style="width:100%">
                                                <thead>
                                                    <tr class="text-nowrap">
                                                        <th class="">P1 Alarm</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            Bitrate Threadhold
                                                            <label
                                                                class="text-end badge bg-light detection-count p1-alarms">
                                                                @if (isset($alarm_collections))
                                                                    {{ $alarm_collections->total_black_count ? $alarm_collections->total_black_count : '0' }}
                                                                @else
                                                                    0
                                                                @endif
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            Latency
                                                            <label
                                                                class="text-end badge bg-light detection-count p1-alarms"
                                                                id="black_detection_count">
                                                                @if (isset($alarm_collections))
                                                                    {{ $alarm_collections->total_black_count ? $alarm_collections->total_black_count : '0' }}
                                                                @else
                                                                    0
                                                                @endif
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            Sync Loss
                                                            <label
                                                                class="text-end badge bg-light detection-count p1-alarms">
                                                                @if (isset($alarm_collections))
                                                                    {{ $alarm_collections->total_black_count ? $alarm_collections->total_black_count : '0' }}
                                                                @else
                                                                    0
                                                                @endif
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            Network Loss
                                                            <label
                                                                class="text-end badge bg-light detection-count p1-alarms">
                                                                @if (isset($alarm_collections))
                                                                    {{ $alarm_collections->total_black_count ? $alarm_collections->total_black_count : '0' }}
                                                                @else
                                                                    0
                                                                @endif
                                                            </label>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- P2 Alarms Table -->
                                        <div class="table-responsive p2-table p2-alarms-table">
                                            <table class="display table" style="width:100%">
                                                <thead>
                                                    <tr class="text-nowrap">
                                                        <th class="">P2 Alarm</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            Black Frames Detection
                                                            <label class="text-end badge bg-light detection-count">
                                                                @if (isset($alarm_collections))
                                                                    {{ $alarm_collections->total_black_count ? $alarm_collections->total_black_count : '0' }}
                                                                @else
                                                                    0
                                                                @endif
                                                            </label>
                                                            @if (isset($alarm_collections) && $alarm_collections->total_black_count > 0)
                                                                <a href="{{ url('stream/alarm/detects') }}/{{ $alarm_collections->camera_id ?? '' }}/black"
                                                                    class="btn btn-primary btn-sm"
                                                                    style="margin-left: 28px;">View</a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            Blur Frames Detection
                                                            <label
                                                                class="text-end badge bg-light detection-count p2-alarms"
                                                                id="blur_detection_count">
                                                                @if (isset($alarm_collections))
                                                                    {{ $alarm_collections->total_blur_count ? $alarm_collections->total_blur_count : '0' }}
                                                                @else
                                                                    0
                                                                @endif
                                                            </label>
                                                            @if (isset($alarm_collections) && $alarm_collections->total_blur_count > 0)
                                                                <a href="{{ url('stream/alarm/detects') }}/{{ $alarm_collections->camera_id ?? '' }}/blur"
                                                                    class="btn btn-primary btn-sm"
                                                                    style="margin-left: 28px;">View</a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            Motion Detection
                                                            <label
                                                                class="text-end badge bg-light detection-count p2-alarms"
                                                                id="motion_detection_count">
                                                                @if (isset($alarm_collections))
                                                                    {{ $alarm_collections->total_motion_detect_count ? $alarm_collections->total_motion_detect_count : '0' }}
                                                                @else
                                                                    0
                                                                @endif
                                                            </label>
                                                            @if (isset($alarm_collections) && $alarm_collections->total_motion_detect_count > 0)
                                                                <a href="{{ url('stream/alarm/detects') }}/{{ $alarm_collections->camera_id ?? '' }}/motion"
                                                                    class="btn btn-primary btn-sm"
                                                                    style="margin-left: 28px;">View</a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            Stream Block Detection
                                                            <label
                                                                class="text-end badge bg-light detection-count p2-alarms">
                                                                @if (isset($alarm_collections))
                                                                    {{ $alarm_collections->total_black_count ? $alarm_collections->total_black_count : '0' }}
                                                                @else
                                                                    0
                                                                @endif
                                                            </label>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>


                                </div>
                            </div>
                            <div class="tab-pane fade" id="tab_5">
                                <div class="table-responsive text-nowrap">
                                    <form action="{{ route('custom_alarm_configration') }}" method="post">
                                        @csrf
                                        @method('POST')
                                        <input type="hidden" id="cust_alarm_cam_id" name="camera_id"
                                            value="{{ $result->camera_id }}">
                                        <input type="hidden" name="region_id" value="{{ $result->region_id }}">
                                        <div class="row" style="margin: 10px;">
                                            <div class="col-md-12" style="margin-top: 10px;">
                                                <div class="form-control" style="height: 4.5rem;">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" name="blur_detection"
                                                            type="checkbox" role="switch" id="blur_detection"
                                                            @checked($custom_alarm && $custom_alarm->blur_detection == 1 ?? false)>
                                                        <label class="form-check-label" for="blur_detection">Blur Frame
                                                            Detection</label>
                                                    </div>
                                                    <small>
                                                        You will get notifictions when stream is not working or any
                                                        techincal error during stream</small>
                                                </div>

                                            </div>
                                            <div class="col-md-12" style="margin-top: 10px;">
                                                <div class="form-control" style="height: 4.5rem;">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" name="black_detection"
                                                            type="checkbox" role="switch" id="black_detection"
                                                            @checked($custom_alarm && $custom_alarm->black_detection == 1 ?? false)>
                                                        <label class="form-check-label" for="black_detection">Black Frame
                                                            Detection</label>
                                                    </div>
                                                    <small>
                                                        You will get notifictions when stream is not working or any
                                                        techincal error during stream</small>
                                                </div>

                                            </div>
                                            <div class="col-md-12" style="margin-top: 10px;">
                                                <div class="form-control" style="height: 4.5rem;">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" name="motion_detection"
                                                            type="checkbox" role="switch" id="motion_detection"
                                                            @checked($custom_alarm && $custom_alarm->motion_detection == 1 ?? false)>
                                                        <label class="form-check-label" for="motion_detection">Motion
                                                            Frame Detection</label>
                                                    </div>
                                                    <small>
                                                        You will get notifictions when stream is not working or any
                                                        techincal error during stream</small>
                                                </div>

                                            </div>

                                            <div class="col-md-12" style="margin-top: 10px;">
                                                <div class="form-control" style="height: 4.5rem;">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" name="enable_disable_stream"
                                                            type="checkbox" role="switch" id="enable_disable_stream"
                                                            @checked($custom_alarm && $custom_alarm->enable_disable_stream == 1 ?? false)>
                                                        <label class="form-check-label"
                                                            for="enable_disable_stream">Enable/Disabe Stream</label>
                                                    </div>
                                                    <small>You will get notifictions when some one start or stop
                                                        stream</small>
                                                </div>
                                            </div>

                                            <div class="col-md-12" style="margin-top: 10px;">
                                                <div class="form-control" style="height: 10.5rem;">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" name="threshold" type="checkbox"
                                                            role="switch" id="threshold" @checked($custom_alarm && $custom_alarm->threshold == 1 ?? false)>
                                                        <label class="form-check-label" for="threshold">Bitrate
                                                            Threadhold</label>
                                                    </div>

                                                    <div class="col-md-6"
                                                        style="margin-top: 10px;>
                                                        <label class="
                                                        form-check-label"="" for="threshold">Select Bitrate Threadhold

                                                        <select name="threshold_value" id="thresholdSelect" onchange="toggleInput('select')"
                                                            style="width: 100px; border: 0.5px solid #d9dee3; border-radius: 4px; padding: 5px; margin-left: 15px;">
                                                            <option value="" @selected($is_custom_threshold == 0)>Please Select</option>
                                                            <option value="240" @selected($custom_alarm && $custom_alarm->threshold_value == 250 ?? false)>240p (250)
                                                            </option>
                                                            <option value="360" @selected($custom_alarm && $custom_alarm->threshold_value == 600 ?? false)>360p (600)
                                                            </option>
                                                            <option value="480" @selected($custom_alarm && $custom_alarm->threshold_value == 1000 ?? false)>480p (1000)
                                                            </option>
                                                            <option value="720" @selected($custom_alarm && $custom_alarm->threshold_value == 2000 ?? false)>720p (2000)
                                                            </option>
                                                            <option value="1080" @selected($custom_alarm && $custom_alarm->threshold_value == 4000 ?? false)>1080p
                                                                (4000)
                                                            </option>
                                                            <option value="1440" @selected($custom_alarm && $custom_alarm->threshold_value == 6000 ?? false)>1440p
                                                                (6000)
                                                            </option>
                                                            <option value="2160" @selected($custom_alarm && $custom_alarm->threshold_value == 10000 ?? false)>2160p
                                                                (10000)
                                                            </option>
                                                        </select>
                                                    </div>

                                                    <div class="col-md-12" style="margin-top: 10px; margin-bottom: 5px;">
                                                        <div class="d-flex align-items-center">
                                                            <label class="form-check-label me-2" for="threshold">Enter custom
                                                                Bitrate Threshold</label>
                                                            <input type="text" class="form-control" id="thresholdInput" oninput="toggleInput('input')"
                                                                name="threshold_value" style="width: 115px; height: 30px" value="{{ $is_custom_threshold == 1 && $custom_alarm != null ? $custom_alarm->threshold_value : "" }}">
                                                        </div>
                                                    </div>


                                                    <small>You will get notifictions bitrate less or equal to selected
                                                        bitrate</small>
                                                </div>
                                            </div>

                                            <div class="col-md-12" style="margin-top: 10px;">
                                                <div class="form-control" style="height: 6.5rem;">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" name="latency" type="checkbox"
                                                            role="switch" id="latency" @checked($custom_alarm && $custom_alarm->latency == 1 ?? false)>
                                                        <label class="form-check-label" for="latency">latency
                                                            Limit</label>
                                                    </div>

                                                    <div class="col-md-6"
                                                        style="margin-top: 10px;>
                                                        <label class="
                                                        form-check-label"="" for="latency">Select time
                                                        <select name="latency_value"
                                                            style="width: 100px; border: 0.5px solid #d9dee3; border-radius: 4px; padding: 5px; margin-left: 15px;">
                                                            <option value="1" @selected($custom_alarm && $custom_alarm->latency_value == 1 ?? false)>1 Second
                                                            </option>
                                                            <option value="2" @selected($custom_alarm && $custom_alarm->latency_value == 2 ?? false)>2 Second
                                                            </option>
                                                            <option value="3" @selected($custom_alarm && $custom_alarm->latency_value == 3 ?? false)>3 Second
                                                            </option>
                                                            <option value="4">Up to 3 seconds</option>
                                                        </select>
                                                    </div>
                                                    <small>You will get notifictions when latency great than or equal
                                                        selected value</small>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="row"
                                            style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
                                            <input style="width: max-content;" type="submit" class="btn btn-primary"
                                                value="Save Settings">
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Advance Layout --}}
                <div class="card p-3 mt-5" id="dark-card2" style="display: none;">
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-bs-toggle="tab" href="#tab1_4"><i
                                        class="bi bi-info-circle-fill me-2"></i>
                                    Alarms</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#tab1_1"><i
                                        class="bi bi-card-text me-2"></i>
                                    Video Statistics</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#tab1_5"><i
                                        class="bi bi-chat-left-text-fill me-2"></i>
                                    Custom Alarms</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade " id="tab1_1" role="tabpane">
                                <div class="row" style="margin-top: 20px;">
                                    <div class="col-md-12">

                                        <div class="row">
                                            <div class="col-md-3">
                                                <label class="text-start">Black Frames Detected</label>
                                            </div>
                                            <div class="col-md-9">
                                                @if (isset($alarm_collections))
                                                    <label class="text-end">
                                                        @if (isset($alarm_collections))
                                                            {{ $alarm_collections->total_black_count ? $alarm_collections->total_black_count : '0' }}
                                                        @else
                                                            "0"
                                                        @endif
                                                    </label>
                                                    <a href="{{ url('stream/alarm/detects') }}/{{ $alarm_collections->camera_id }}/black"
                                                        style=" margin-left: 28px; padding-left: 5px; padding-bottom: 0px; padding-top: 1px; padding-right: 6px; "
                                                        class="btn btn-primary btn-sm">View</a>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-3">
                                                <label class="text-start">Blur Frames Detected</label>
                                            </div>
                                            <div class="col-md-9">
                                                @if (isset($alarm_collections))
                                                    <label
                                                        class="text-end">{{ $alarm_collections->total_blur_count ? $alarm_collections->total_blur_count : '0' }}</label>
                                                    <a href="{{ url('stream/alarm/detects') }}/{{ $alarm_collections->camera_id }}/blur"
                                                        style=" margin-left: 21px; padding-left: 5px; padding-bottom: 0px; padding-top: 1px; padding-right: 6px; "
                                                        class="btn btn-primary btn-sm">View</a>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-3">
                                                <label class="text-start">Stream Disabled</label>
                                            </div>
                                            <div class="col-md-9">
                                                <label class="text-end">No</label>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="tab1_3">
                                <div class="pt-4 hidden" id="show_media_tab1_3">

                                </div>
                            </div>
                            <div class="tab-pane fade active show" id="tab1_4">
                                <ul id="myList2" style="font-size: 16px; list-style-type: square; padding: 10px;">
                                </ul>

                            </div>
                            <div class="tab-pane fade" id="tab1_5">
                                <div class="table-responsive text-nowrap">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card p-3 mt-5" id="dark-card3" style="display: none;">
                    <h2 class="text-white text-center">No Detection</h2>
                </div>
            </div>

            <div id="loading" style=" text-align: center; padding: 51px; ">
                <img src="{{ asset('infinite-spinner.svg') }}" style="width:300px;" />
            </div>
        </div>
    </div>
    <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
    <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>
    <link href="https://vjs.zencdn.net/7.20.3/video-js.css" rel="stylesheet" />
    {{-- <script src="https://vjs.zencdn.net/7.20.3/video.min.js"></script> --}}
    <script src="https://vjs.zencdn.net/7.20.3/video.js"></script>

    <script>
        function applyClassToElements(targetClass, newClass) {
            // Select all elements with the target class
            const elements = document.querySelectorAll(`.${targetClass}`);

            // Loop through all selected elements and apply the new class
            elements.forEach(element => {
                element.classList.add(newClass);
            });
        }

        // Enable pusher logging - don't include this in production
        Pusher.logToConsole = true;
        var pusher = new Pusher(
            '{{ env('PUSHER_APP_KEY') }}', {
                cluster: '{{ env('PUSHER_APP_CLUSTER') }}'
            });

        var channel = pusher.subscribe('my-channel');

        channel.bind('my-event', function(data) {
            // var msgg = data['message'];
            console.log(data.message);
            var _data = data.message

            cam_id = document.getElementById('cust_alarm_cam_id').value;

            if (cam_id == _data.camera_id) { // show only currnet camera notification
                if (_data.type == "blur_detected") {
                    incrementCounter('blur_detection_count')
                }
                if (_data.type == "black_detected") {
                    // var ulElement = document.getElementById('myList');
                    // var newLiElement = document.createElement('li');

                    // // Create icon element
                    // var iconElement = document.createElement('i');

                    // // Set different icons based on the detection type
                    // if (_data.type == "black_detected") {
                    //     iconElement.className =
                    //         "fas fa-exclamation-triangle"; // Icon for black_detected (Warning triangle)
                    // } else if (_data.type == "blur_detected") {
                    //     iconElement.className = "fas fa-tint-slash"; // Icon for blur_detected (Droplet slash)
                    // }

                    // // Append the icon and text to the list item
                    // newLiElement.appendChild(iconElement);
                    // // newLiElement.appendChild(document.createTextNode(" " + _data.type + " in " + _data.camera_name));
                    // if (_data.type == "black_detected") {
                    //     newLiElement.appendChild(document.createTextNode(" Black Detected "));

                    // } else if (_data.type == "blur_detected") {
                    //     newLiElement.appendChild(document.createTextNode(" Blur Detected "));

                    // }


                    // ulElement.appendChild(newLiElement);
                    incrementCounter('black_detection_count')

                }

                if (_data.type == "motion_detection") {
                    // var ulElement = document.getElementById('myList2');
                    // var newLiElement = document.createElement('li');

                    // // Create icon element for motion detection
                    // var iconElement = document.createElement('i');
                    // iconElement.className = "fas fa-bullseye"; // Change to a bullseye detection icon

                    // // Append the icon and text to the list item
                    // newLiElement.appendChild(iconElement);
                    // // newLiElement.appendChild(document.createTextNode(" " + _data.type + " in " + _data.camera_name));
                    // newLiElement.appendChild(document.createTextNode(" Motion Detected "));


                    // ulElement.appendChild(newLiElement);


                    incrementCounter('motion_detection_count')
                }
            }

            // alert(JSON.stringify(data));
        });


        function incrementCounter(elementId) {
            var element = document.getElementById(elementId);

            var count = parseInt(element.innerHTML, 10);

            count++;

            element.innerHTML = count;
        }



        $(document).ready(function() {
            $.ajax({
                type: 'GET',
                url: '{{ url('container/info') }}?container={{ $container }}',
                data: {
                    _token: '<?php echo csrf_token(); ?>'
                },
                dataType: 'json',
                success: function(data) {
                    console.log(data);
                    document.getElementById('top_layout').style.display = "block";
                    document.getElementById('loading').style.display = "none";
                    if (data.error == false) {
                        $("#col_id").html(data.data);
                    } else {
                        $("#col_id").html(
                            '<span class="badge badge-circle badge-dark light text-danger">Terminated</i> </span>'
                        );
                    }
                },
                error: function(xhr, status, error) {
                    // Handle error
                    document.getElementById('top_layout').style.display = "block";
                    document.getElementById('loading').style.display = "none";
                    console.error(xhr.responseText); // Log the error response
                    console.error(status); // Log the status of the error
                    console.error(error); // Log the error message
                    // You can also display an error message to the user
                    // alert('An error occurred while processing your request. Please try again later.');
                }
            });
        });

        function change_layout(type) {

            if (type == 1) {
                document.getElementById("dark-card1").style.display = "block";
                document.getElementById("dark-card2").style.display = "none";

            } else if (type == 2) {
                document.getElementById("dark-card1").style.display = "none";
                document.getElementById("dark-card2").style.display = "block";
            } else if (type == 3) {
                document.getElementById("dark-card1").style.display = "none";
                document.getElementById("dark-card2").style.display = "none";
                document.getElementById("dark-card3").style.display = "block";

            }

        }


        document.addEventListener('DOMContentLoaded', function() {
            // Get the container element by its ID
            var container = document.getElementById('show_media_tab_3');
            var container_tab1_3 = document.getElementById('show_media_tab1_3');

            // Get the media URL from the server-side variable
            var mediaUrl = "{{ $result['stream_url'] }}";
            // Example mediaUrl: "http://142.0.109.159/axis-cgi/mjpg/video.cgi"

            fetch(`{{ url('/get-stream-metadata') }}?stream_url=${encodeURIComponent(mediaUrl)}`)
                .then(response => response.json())
                .then(data => {
                    const videoStream = data.data.streams.find(stream => stream.codec_type === 'video');

                    if (videoStream) {
                        let mediaHTML = '';

                        if (data.video_type == 'normal') {
                            console.log('Using Video.js player');
                            // Define the video formats and their corresponding MIME types
                            const allVideoFormat = {
                                'mpd': "application/dash+xml",
                                'mp4': "video/mp4",
                                'webm': "video/webm",
                                'ogg': "video/ogg",
                                'm3u8': "application/x-mpegURL",
                                'mjpeg': "video/x-motion-jpeg",
                                'avi': "video/x-msvideo",
                                'mov': "video/quicktime",
                                'mkv': "video/x-matroska",
                                '3gp': "video/3gpp",
                                '3g2': "video/3gpp2",
                                'asf': "video/x-ms-asf",
                                'flv': "video/x-flv",
                                'f4v': "video/x-f4v",
                                'ts': "video/mp2t",
                                'mpeg': "video/mpeg",
                                'mpg': "video/mpeg",
                                'wmv': "video/x-ms-wmv",
                                'divx': "video/divx",
                                'xvid': "video/xvid",
                                'vob': "video/dvd",
                                'mts': "video/avchd",
                                'm2ts': "video/avchd",
                                'hevc': "video/hevc",
                                'h264': "video/h264",
                                'h265': "video/h265",
                                'dv': "video/x-dv",
                                'rm': "application/vnd.rn-realmedia",
                                'rv': "video/vnd.rn-realvideo",
                                'drc': "video/x-dirac"
                            };

                            // Define the image formats and their corresponding MIME types
                            const allImageFormat = {
                                'jpg': "image/jpeg",
                                'jpeg': "image/jpeg",
                                'png': "image/png",
                                'gif': "image/gif",
                                'bmp': "image/bmp",
                                'webp': "image/webp",
                                'svg': "image/svg+xml"
                            };

                            // Extract the file extension from the URL
                            var fileExtension = mediaUrl.split('.').pop().split(/\#|\?/)[0].toLowerCase();

                            if (fileExtension === 'cgi' || fileExtension === 'mjpg' || fileExtension ===
                                'mjpeg') {
                                // URL is an MJPEG stream
                                mediaHTML = `
                            <img src="${mediaUrl}" alt="MJPEG Stream" width="300" />
                        `;
                            } else if (allVideoFormat[fileExtension]) {
                                // URL is a video
                                var mimeType = allVideoFormat[fileExtension];
                                mediaHTML = `
  <video id="my-video" class="video-js vjs-default-skin" controls preload="auto"
    width="300" height="170" data-setup='{}'>
    <source src="${mediaUrl}" type="${mimeType}" />
    <!-- Fallback -->
    <p>Your browser does not support the video tag.</p>
  </video>
`;
                            } else if (allImageFormat[fileExtension]) {
                                // URL is an image
                                var mimeType = allImageFormat[fileExtension];
                                mediaHTML = `
                            <img src="${mediaUrl}" alt="Media Image" width="640" />
                        `;
                            } else {
                                // Unknown format
                                mediaHTML = `<p>Unsupported media format.</p>`;
                            }

                        } else {
                            console.log('Using YouTube player');
                            // Assuming the video URL is a YouTube link
                            var videoId = mediaUrl.split('v=')[1];
                            var ampersandPosition = videoId.indexOf('&');
                            if (ampersandPosition != -1) {
                                videoId = videoId.substring(0, ampersandPosition);
                            }

                            // Create the YouTube embed URL
                            var youtubeEmbedUrl = `https://www.youtube.com/embed/${videoId}`;

                            // Generate the HTML for the YouTube player with the specified size
                            mediaHTML = `
                        <iframe width="600" height="300" src="${youtubeEmbedUrl}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

                    `;
                        }

                        const content = `
                    <div class="row">
                        <div class="col-md-12 d-flex justify-content-center">
                            ${mediaHTML}
                        </div>
                    </div>
                `;

                        container.innerHTML = content;
                        // container_tab1_3.innerHTML = content;


                        if (data.video_type == 'normal') {
                            videojs('my-video');
                        }

                    }

                })
                .catch(error => {
                    console.error('Error fetching stream metadata:', error);
                });
        });



        window.addEventListener("load", function() {
            const detectionCountElements = document.querySelectorAll(".detection-count");

            detectionCountElements.forEach(element => {
                const textContent = element.textContent.trim();
                const count = parseInt(textContent, 10);

                if (count > 0 && element.classList.contains('p2-alarms')) {
                    document.getElementById('p2-alarm-staus').classList.add("blinking-text");
                    element.classList.add("blinking-text");
                    element.classList.remove("bg-light");
                    element.classList.add("bg-warning");
                }

                if (count > 0 && element.classList.contains('p1-alarms')) {
                    document.getElementById('p1-alarm-staus').classList.add("blinking-text");
                    element.classList.add("blinking-text");
                    element.classList.remove("bg-light");
                    element.classList.add("bg-danger");
                }
            });
        });


        function toggleHighlightTable(tableClass) {
            // Select the tables
            const p1Table = document.querySelector('.p1-alarms-table');
            const p2Table = document.querySelector('.p2-alarms-table');

            // Check the parameter and apply/remove classes accordingly
            if (tableClass === 'p1-alarms-table') {
                p1Table.classList.add('highlight-border'); // Add highlight to P1 table
                p2Table.classList.remove('highlight-border'); // Remove highlight from P2 table
            } else if (tableClass === 'p2-alarms-table') {
                p2Table.classList.add('highlight-border'); // Add highlight to P2 table
                p1Table.classList.remove('highlight-border'); // Remove highlight from P1 table
            }
        }

        window.addEventListener('load', function() {
            toggleHighlightTable('p1-alarms-table');
        });


        function removeSelectedFromDropdown() {
        const select = document.getElementById('thresholdSelect');
        // If any option is selected by default, reset the selection
        select.value = ""; // Ensures no option is selected
    }

    // Event to remove the default selected option on page load
    // window.onload = function() {
    //     removeSelectedFromDropdown(); // Remove pre-selected option
    // };

    function toggleInput(source) {
        const select = document.getElementById('thresholdSelect');
        const input = document.getElementById('thresholdInput');

        if (source === 'select') {
            // If the user selects a dropdown option, clear the input value
            input.value = "";
            // Remove name from input field
            input.removeAttribute('name');
            // Assign the name to the select field
            select.setAttribute('name', 'threshold_value');
        } else if (source === 'input') {
            // If user types a custom value, select "Please select" option in the dropdown
            if (input.value.trim() !== "") {
                select.value = ""; // Automatically select "Please select"
                // Remove name from the select field
                select.removeAttribute('name');
                // Assign the name to the input field
                input.setAttribute('name', 'threshold_value');
            } else {
                // If input is cleared, reassign the name to the select field
                select.setAttribute('name', 'threshold_value');
                input.removeAttribute('name');
            }
        }
    }
    </script>
@endSection
