<?php

use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
    // return view('welcome');
});

Route::get('/home', function () {
    return redirect()->route('dash');
});

Route::get('/t2', function () {

    $data = "abdullah";
    $key = 'mPQKWfKQ4nvMlKpAA4SFIcIgInnXMpVI'; // Ensure it's 32 bytes for AES-256
    $cipher = 'AES-256-CBC';
    $iv = \Str::random(16); // Generate a random IV

    // Encrypt the data
    $encryptedData = openssl_encrypt($data, $cipher, $key, 0, $iv);

    // Return encrypted data along with the IV
    return response()->json([
        'encryptedData' => $encryptedData,
        'iv' => $iv
    ]);
});

Route::get('logout', [App\Http\Controllers\Auth\LoginController::class, 'logout']);
Route::get('dashboard', [App\Http\Controllers\FrontController::class, 'index'])->name("dash");
Route::get('all/regions', [App\Http\Controllers\FrontController::class, 'AllRegions'])->name("regions.all");
Route::get('cameras/{pagenumber}/{regionid}', [App\Http\Controllers\FrontController::class, 'cameras'])->name("cameras.list");
Route::get('camera/views/{camera_id}', [App\Http\Controllers\FrontController::class, 'cameras_details'])->name("camera.details");
Route::get('camera/faces/{frame_id}', [App\Http\Controllers\FrontController::class, 'faceDetections'])->name("face.list");
Route::get('frame/faces/{frame_id}', [App\Http\Controllers\FrontController::class, 'getFaceFrameData']);
Route::get('frame/main/{frame_id}', [App\Http\Controllers\FrontController::class, 'view_main_frame']);
Route::post('frame/generate_video/', [App\Http\Controllers\FrontController::class, 'generate_video'])->name('generate_frame_video');






// SearchController
Route::get('forensic/search', [App\Http\Controllers\SearchController::class, 'index'])->name('forensic.search');
Route::get('data/find/faces', [App\Http\Controllers\SearchController::class, 'testEventData']);
Route::get('search/face/{id}', [App\Http\Controllers\SearchController::class, 'search_face_byId']);
Route::post('data/find/search', [App\Http\Controllers\SearchController::class, 'search'])->name("data.find.search");

// AddDatacontroller


Route::get('region/add', [App\Http\Controllers\AddDataController::class, 'add_region_view'])->name("region.add");
Route::post('region/add', [App\Http\Controllers\AddDataController::class, 'add_new_region'])->name("region.save");
Route::post('camera/add', [App\Http\Controllers\AddDataController::class, 'updateCamera'])->name("camera.update");
Route::post('camera/update', [App\Http\Controllers\AddDataController::class, 'add_new_camera'])->name("camera.save");
Route::get('add_camera_view/{id}/add', [App\Http\Controllers\AddDataController::class, 'add_camera_view'])->name("camera.add");
Route::get('add_camera_view/add', [App\Http\Controllers\AddDataController::class, 'add_camera2_view'])->name("camera.add.origin");
Route::get('find/camera/{id}/add', [App\Http\Controllers\AddDataController::class, 'findCamera'])->name("camera.find");
Route::get('delete/camera/{id}', [App\Http\Controllers\AddDataController::class, 'deleteCamera'])->name("camera.delete");
Route::get('all/cameras/{region}', [App\Http\Controllers\AddDataController::class, 'view_all_cameras'])->name("all.cameras.lists");
Route::get('all/cameras/', [App\Http\Controllers\AddDataController::class, 'view_only_cameras'])->name("only.cameras.lists");
Route::get('all/regions/lists', [App\Http\Controllers\AddDataController::class, 'all_regions_views'])->name("all.rigions.lists");
Route::get('regions/{id}/edit', [App\Http\Controllers\AddDataController::class, 'edit_origin'])->name("find.region");
Route::post('update/region', [App\Http\Controllers\AddDataController::class, 'update_region'])->name("update.region");
Route::get('attendance/face/add/{id}', [App\Http\Controllers\AddDataController::class, 'add_faces'])->name("faces.add");
Route::post('face/add', [App\Http\Controllers\AddDataController::class, 'save_faces'])->name("faces.add.post");
Route::get('face/all/{camera_id?}', [App\Http\Controllers\AddDataController::class, 'faces_all'])->name("faces.all");
Route::get('face/detail/{face_id?}', [App\Http\Controllers\AddDataController::class, 'face_detail'])->name("faces.face_detail");
Route::get('face_delete/{id}', [App\Http\Controllers\AddDataController::class, 'delete_face'])->name("faces.delete");
Route::get('camera_with_stream/add/{region_id?}', [App\Http\Controllers\AddDataController::class, 'add_streamWithCamera'])->name("streamWithCamera.add");
Route::post('camera_with_stream/add', [App\Http\Controllers\AddDataController::class, 'save_streamWithCamera'])->name("streamWithCamera.save");
Route::post('camera/custom-alarm/save/', [App\Http\Controllers\AddDataController::class, 'custom_alarm_configration'])->name("custom_alarm_configration");
Route::get('get-stream-metadata', [App\Http\Controllers\AddDataController::class, 'verify_stream'])->name('verify_stream');

Route::post('extact/frame/faces', [App\Http\Controllers\AddDataController::class, 'extact_frame_faces'])->name("extact_frame_faces");


// new code



Route::get('camera/{camera_id}/statistics/', [App\Http\Controllers\AddDataController::class, 'camera_statistics'])->name("camera.statistics");
Route::get('camera/{camera_id}/monitor/', [App\Http\Controllers\AddDataController::class, 'monitor_stream'])->name("camera.monitor");

Route::get('container/info', [App\Http\Controllers\AddDataController::class, 'get_container_info']);
Route::get('camera/{id}/settings', [App\Http\Controllers\AddDataController::class, 'camera_stream_setting'])->name('camera.stream.setings');
Route::post('store/camera/settings', [App\Http\Controllers\AddDataController::class, 'store_camera_stream_setting'])->name('store.stream.setings');



Route::get('stream/alarm/detects/{camera_id}/{type}', [App\Http\Controllers\AlarmDetectController::class, 'index'])
    ->name('stream.alarm.detects');

Route::get('stream/frame/detected/{camera_id}/{page?}', [App\Http\Controllers\ForensicController::class, 'index'])
    ->name('stream.frame.detected');




Route::get('stream/face/detected/{camera_id}/{frame_id}', [App\Http\Controllers\ForensicController::class, 'face_detected_list'])
    ->name('stream.face.detected');

Route::get('virtial/wall/view/{region_id?}', [App\Http\Controllers\VirtualWallController::class, 'index']);

Route::get('virtial/wall/load/preset/{preset_id}', [App\Http\Controllers\VirtualWallController::class, 'loadPreset']);


Route::get('virtial-wall/view', [App\Http\Controllers\VirtualWallController::class, 'get_cameras_stream'])
    ->name('virtial.wall.view');

Route::post('virtial-wall/view', [App\Http\Controllers\VirtualWallController::class, 'preset_save'])
    ->name('preset_save');

Route::get('virtial-wall/preset/delete/{preset_id}', [App\Http\Controllers\VirtualWallController::class, 'preset_delete'])
    ->name('preset_delete');


Route::get('attendance/list/{camera_id}', [App\Http\Controllers\AttendanceController::class, 'index'])
    ->name('attendance.list');



Route::get('attendance/setup/{camera_id}', [App\Http\Controllers\AttendanceController::class, 'setup_attendance'])
    ->name('attendance.setup');


Route::post('attendance/store/', [App\Http\Controllers\AttendanceController::class, 'store_lines'])
    ->name('attendance.line');


Route::get('attendance/report/{camera_id?}/{page?}', [App\Http\Controllers\AttendanceController::class, 'attendance_report'])
    ->name('attendance.report');

Route::get('monitor/attendee/{camera_id}', [App\Http\Controllers\AttendanceController::class, 'monitor_attendance'])
    ->name('monitor.attendance');


Route::get('attendance/match/faces/{face_id?}', [App\Http\Controllers\AttendanceController::class, 'match_faces'])
    ->name('attendance.match_faces');

// Route::get('attendance/match/faces/{face_id?}', [App\Http\Controllers\AttendanceController::class, 'match_faces'])
// ->name('attendance.match_faces');

// ACCESS CONTROLL

Route::get('attendance', [App\Http\Controllers\AttendanceController::class, 'access_control_attendance_sys'])
    ->name('attendance.access_control_attendance_sys');


// OBJECT COUNT

Route::get('object/counter', [App\Http\Controllers\AttendanceController::class, 'object_counter'])
    ->name('attendance.object_counter');

Route::get('object/counter/detail/view/{camera_id}/', [App\Http\Controllers\AttendanceController::class, 'object_counter_detail_view'])
    ->name('attendance.object_counter_detail_view');

Route::get('object/counter/detail/{camera_id}/{page?}', [App\Http\Controllers\AttendanceController::class, 'object_counter_detail'])
    ->name('attendance.object_counter_detail');

Route::get('object/counter/attendee/{frame_id?}', [App\Http\Controllers\AttendanceController::class, 'view_attendee'])
    ->name('attendance.object_counter_view_attendee');

// MOTION DETECTION
Route::get('motion/detection', [App\Http\Controllers\MotionDetectionController::class, 'index'])->name('motion_detection_index');
// Route::get('motion-detection/{region_id}', [App\Http\Controllers\MotionDetectionController::class, 'getMotionDetectionDetails_region'])->name('motion_detection_details_region');
Route::get('motion-detection/{camera_id}', [App\Http\Controllers\MotionDetectionController::class, 'getMotionDetectionDetails_camera'])->name('motion_detection_details_camera');



// ADMIN PORTAL

Route::get('admin/portal/{camera_id?}', [App\Http\Controllers\AdminPortalController::class, 'index'])->name("admin_portal_index");
Route::post('admin/portal/save/', [App\Http\Controllers\AdminPortalController::class, 'store'])->name("admin_portal_store");






// STREAMS
Route::get('view/stream', function () {
    return view('streams.view_stream');
});
Route::get('Camera_and_stream_management', function () {
    return view('enviz_enrich.enrich');
})->name('video-enrichment');


//AlarmController

Route::get('alarm/settings', [App\Http\Controllers\AlarmController::class, 'index'])
    ->name("alarm.settings.view");



Route::post('save/alarm/settings', [App\Http\Controllers\AlarmController::class, 'update_settings'])
    ->name("save.alarm.setting");


// AjaxController
Route::post('cameras', [App\Http\Controllers\AjaxController::class, 'totalCameras'])->name("cameras.all");
Route::get('genderage/data', [App\Http\Controllers\AjaxController::class, 'LoadGenderAgeData']);
Route::post('genderage/data', [App\Http\Controllers\AjaxController::class, 'LoadGenderAgeData'])->name("general.data");
Route::get("t", function () {

    $uri = "mongodb://localhost:27017"; // Replace with your local MongoDB server's address and port
    $client = new MongoDB\Client(
        $uri,
        [],
        ['typeMap' => ['root' => 'array', 'document' => 'array']]
    );

    // $uri = "mongodb+srv://abdullahmasoodx:miG0JPZFrg2LJn6U@imageprocessing.vjt2aot.mongodb.net/?retryWrites=true&w=majority";

    // $client = new MongoDB\Client(
    //     $uri
    // );

    //$database = $client->framedata;
    //  $database->command(['ping'=>1]);
    $collection = $client->dataprocess->imagesinfo;

    $cursor = $collection->countDocuments();
    echo "Total documents in the collection: " . $cursor;


    //     $filter = [];

    //     $projection = [
    //         'actual_frame_path' => 0,
    //         'frame_image' => 0,
    //         'created_at' => 0,
    //         "frame_id" => 0,
    //         "_id" => 0,
    //         "face_details.BoundingBox" => 0,
    //         "face_details.Smile" => 0,
    //         "face_details.Eyeglasses" => 0,
    //         "face_details.Sunglasses" => 0,
    //         "face_details.Beard" => 0,
    //         "face_details.Mustache" => 0,
    //         "face_details.MouthOpen" => 0,
    //         "face_details.EyesOpen" => 0,
    //         "face_details.Emotions" => 0,
    //         "face_details.Landmarks" => 0,
    //         "face_details.Pose" => 0,
    //         "face_details.Quality" => 0,
    //         "face_details.FaceOccluded" => 0,
    //         "face_details.EyeDirection" => 0,
    //         // ]
    //     ];

    //     $options = [];

    //     $cursor = $collection->find($filter, ['projection' => $projection] + $options);
    //     //
    //     $genderData = [];
    //     foreach ($cursor as $result) {
    //         $genderData[] = $result['face_details']['AgeRange'];
    //     }
    //    // return $genderData;
    //     return view("text", compact('genderData'));
});




Route::post('/your-route-url', function () {
    // Your server-side logic here
    return response()->json(['message' => 'Request received successfully']);
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

// TEST DESIGN
Route::get('/test-design', function () {
    return view('test-design.test');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');



// Route::get('/get-stream-metadata', function (Request $request) {
//     $streamUrl = $request->query('stream_url', 'https://video.codxcanvas.com/sample1.mp4');

//     $response = Http::withHeaders([
//         'Content-Type' => 'application/json',
//     ])->post('http://127.0.0.1:5000/get_stream_metadata', [
//                 'stream_url' => $streamUrl
//             ]);

//     dd($response->json());
// });

Route::get('/proxy/video', function () {
    // Get the video URL from the query string
    $videoUrl = request()->query('url'); // E.g., /proxy/video?url=https://video.example.com/video.mp4

    if (!$videoUrl) {
        return response()->json(['error' => 'No URL provided'], 400);
    }

    $decodedUrl = urldecode($videoUrl);
    // Fetch the video content from the external server
    $response = Http::timeout(60)->get($decodedUrl); // Set timeout to 60 seconds

    // Check if the request was successful
    if ($response->successful()) {
        // Return the video content with proper CORS headers
        return Response::make($response->body(), 200, [
            // 'Content-Type' => $response->header('Content-Type'),
            // 'Content-Length' => $response->header('Content-Length'),
            'Access-Control-Allow-Origin' => '*', // Allow all origins
            'Access-Control-Allow-Methods' => 'GET, OPTIONS',
        ]);
    }

    // Return an error response if the external server fails
    return response()->json(['error' => 'Unable to fetch video'], 500);
})->name('proxy_video');


