<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Cameras List</h4>
            </div>
            </a>
            <div class="card-body">

                <div class="table-responsive text-nowrap">
                    <table class="display" id="example2" style="width:100%">
                        <thead>
                            <tr class="text-nowrap">
                                <th>#</th>
                                <th>Camera Name</th>
                                <th>Streaming URl</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($cameras): ?>
                                <?php $__currentLoopData = $cameras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e(++$index); ?></th>
                                        <td><?php echo e($list['cameraname']); ?></td>
                                        <td><?php echo e($list['stream_url']); ?></td>
                                        <td>
                                            <?php if($list['status'] == 1): ?>
                                                <span class="badge bg-success ">Active</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger badge-sm">Disconnected</span>
                                            <?php endif; ?>
                                        </td>

                                        <td><a href="<?php echo e(route('camera.details', $list['_id'])); ?>"
                                                class="btn btn-primary  btn-sm">Open Camera</a>


                                            
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                        </tbody>
                    </table>
                </div>

            </div>
        </div>


        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
            
            
        </div>


    </div>
    </div>
    </div>


    <script>
        function deleteCamera(id) {
            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "<?php echo e(url('delete/camera/')); ?>/" + id;
                }
            });
        }
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\surveillance\resources\views/stream/cameras.blade.php ENDPATH**/ ?>