<?php $__env->startSection('content'); ?>
    <style>
        select option {
            background-color: #007bff !important;
            color: white !important;
        }


        table {
            transform: scale(1);
            transform-origin: top left;
        }


        table.dataTable thead .sorting,
        table.dataTable thead .sorting_asc,
        table.dataTable thead .sorting_desc,
        table.dataTable thead .sorting_asc_disabled,
        table.dataTable thead .sorting_desc_disabled {
            background-image: url('https://cdn.datatables.net/1.10.24/images/sort_both.png');
            background-repeat: no-repeat;
            background-position: center right;
            cursor: pointer;
        }

        table.dataTable thead .sorting_asc {
            background-image: url('https://cdn.datatables.net/1.10.24/images/sort_asc.png');
        }

        table.dataTable thead .sorting_desc {
            background-image: url('https://cdn.datatables.net/1.10.24/images/sort_desc.png');
        }

        /* Remove hover-only display */
        table.dataTable thead>tr>th.sorting:before,
        table.dataTable thead>tr>th.sorting:after,
        table.dataTable thead>tr>th.sorting_asc:before,
        table.dataTable thead>tr>th.sorting_asc:after,
        table.dataTable thead>tr>th.sorting_desc:before,
        table.dataTable thead>tr>th.sorting_desc:after,
        table.dataTable thead>tr>th.sorting_asc_disabled:before,
        table.dataTable thead>tr>th.sorting_asc_disabled:after,
        table.dataTable thead>tr>th.sorting_desc_disabled:before,
        table.dataTable thead>tr>th.sorting_desc_disabled:after {
            opacity: 1 !important;
        }
    </style>

    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card" style="display: grid;height: 100%;">
            <div class="card-header">
                <h4 class="card-title">Object Counter
                </h4>
            </div>


            <div class="row container">
                <div class="col-md-2 d-flex align-items-center">
                    <h3 class="">Filters:</h3>
                </div>
                <div class="col-md-3 d-flex align-items-center">
                    <input type="text" class="form-control" id="searchCamera" placeholder="Search Camera">
                    
                </div>
                <div class="col-md-3 d-flex align-items-center">
                    <input type="text" class="form-control" id="searchRegion" placeholder="Search Region">
                    
                </div>
                
            </div>

            <div class="table-responsive text-nowrap container">
                <table class="display table " id="myDataTable">
                    <thead>
                        <tr class="text-nowrap">
                            <th>#</th>
                            <th>Camera Name</th>
                            <th>Region Name</th>
                            
                            <th>View Detail</th>
                            


                        </tr>
                    </thead>
                    <tbody>
                        
                        <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th scope="row"><?php echo e($loop->iteration); ?></th> <!-- Use $loop->iteration for row number -->
                                <td>
                                    
                                    <a href="#">
                                        <?php echo e($item['cameraname']); ?>

                                    </a>
                                </td>
                                <td>
                                    <?php echo e($item['regionInfo']['region'] ?? ""); ?>

                                </td>

                                
                                <td>
                                    <a href="<?php echo e(route('attendance.object_counter_detail_view', $item['_id'])); ?>"
                                        class="btn btn-sm
                                        <?php if(!isset($item['attendeeInfo']) || $item['attendeeInfo'] == 0): ?> disabled btn-default <?php else: ?> btn-secondary <?php endif; ?>
                                        ">
                                        View
                                    </a>
                                </td>

                                

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
            
            
        </div>



        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Attendee</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div id="showFaces" class="d-flex justify-content-center flex-wrap">
                            Fetching records....
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>


        <div class="modal fade" id="modalCenter2" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered  modal-md" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCenterTitle">Object Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Class Name</th>
                                        <th>Confidence</th>
                                    </tr>
                                </thead>
                                <tbody id="table-body">
                                    <!-- Data will be inserted here using JavaScript -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>


    </div>


    <script>
        function viewAttendee(cameraId) {
            console.log(cameraId);

            $.ajax({
                url: '<?php echo e(route('attendance.object_counter_view_attendee', ':id')); ?>'.replace(':id',
                    cameraId), // Replace ':id' with the actual faceId
                type: 'GET', // or 'POST' if your route expects a POST request
                success: function(response) {
                    // response = response['photo_face_record']

                    // Clear the #showFaces div before appending new images
                    $('#showFaces').empty();

                    // Assuming 'response' is your array containing base64 image strings
                    response.forEach(function(item) {
                        // Create a new img element for each detected_face_frame
                        var imgElement = $('<img>', {
                            src: 'data:image/png;base64,' + item
                                .detected_face_frame, // Set the src attribute
                            style: 'width: 100px; height: 100px; margin: 5px;', // Set styles as needed
                            alt: 'Matched Face'
                        });



                        // Append the img element to the #showFaces div
                        $('#showFaces').append(imgElement);
                    });

                },
                error: function(xhr, status, error) {
                    // Handle any errors here
                    console.error('Error:', status, error);
                    $('#showFaces').empty();

                }
            });
        }


        document.getElementById('modalCenter2').addEventListener('show.bs.modal', (e) => {
            var jsonData = e.relatedTarget.dataset.data;
            //alert("sd");
            console.log(JSON.parse(jsonData));
            populateTable(JSON.parse(jsonData));
        });


        function populateTable(data) {
            const tableBody = document.getElementById('table-body');
            tableBody.innerHTML = '';

            data.forEach(item => {
                const row = document.createElement('tr');
                row.innerHTML = `
                <td>${item.class}</td>
                <td>${item.confidence * 100} %</td>

            `;
                tableBody.appendChild(row);
            });
        }


        $(document).ready(function() {
            $('#exampleModal').on('hidden.bs.modal', function() {
                $('#showFaces').html(
                    'Fetching records. please wait ....'); // Clear the inner HTML of the div
            });
        });



        $(document).ready(function() {
            $('#myDataTable').DataTable({
                searching: true,
                ordering: true,
                info: false,
                lengthChange: false, // This line hides the entries dropdown
                pageLength: 10, // Optional: Set default number of entries per page
                "order": [], // Disable initial sorting
                "columnDefs": [{
                        "orderable": true,
                        "targets": "_all"
                    }, // Make all columns orderable
                    {
                        "type": "string",
                        "targets": "_all"
                    } // Treat all column data as strings for sorting
                ],
                language: {
                    paginate: {
                        previous: "<i class='fas fa-angle-left'></i>", // Icon for previous button
                        next: "<i class='fas fa-angle-right'></i>" // Icon for next button
                    }
                }
            });


            $("#searchCamera").on('keyup', function() {
                $('#myDataTable').DataTable().column(1).search(
                    $(this).val(),
                    false, // regex
                    true // smart search
                ).draw();
            });

            $("#searchRegion").on('keyup', function() {
                $('#myDataTable').DataTable().column(2).search(
                    $(this).val(),
                    false, // regex
                    true // smart search
                ).draw();
            });

            $("#searchUrl").on('keyup', function() {
                $('#myDataTable').DataTable().column(3).search(
                    $(this).val(),
                    false, // regex
                    true // smart search
                ).draw();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\surveillance\resources\views/attendance/object_counter.blade.php ENDPATH**/ ?>