<?php $__env->startSection('content'); ?>
    
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Regions List</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="example4" class="display" style="min-width: 845px">
                        <thead>
                            <tr class="text-nowrap">
                                <th>#</th>
                                <th>Region Name</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th scope="row"><?php echo e(++$index); ?></th>

                                    <td><?php echo e($list['region']); ?></td>

                                    <td>
                                        <?php if(isset($list['status']) && $list['status'] == 1): ?>
                                            <span class="badge bg-success ">Active</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger badge-sm">Disabled</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(App\Helper\HelperData::convertTimeStamp($list['created_at'])); ?></td>
                                    <td>

                                        <div class="dropdown ms-auto text-end">
                                            <div class="btn-link" data-bs-toggle="dropdown">
                                                <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                        <rect x="0" y="0" width="24" height="24"></rect>
                                                        <circle fill="#ffffff" cx="5" cy="12" r="2"></circle>
                                                        <circle fill="#ffffff" cx="12" cy="12" r="2"></circle>
                                                        <circle fill="#ffffff" cx="19" cy="12" r="2"></circle>
                                                    </g>
                                                </svg>
                                            </div>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('find.region', [$list['_id']])); ?>">Edit</a>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('camera.add', [$list['_id']])); ?>">New
                                                    Camera/Stream</a>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('all.cameras.lists', [$list['_id']])); ?>">Stream/Camera
                                                    List</a>
                                            </div>
                                        </div>


                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th>Region Name</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>




                
            </div>
        </div>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\surveillance\resources\views/add/regions_all_list.blade.php ENDPATH**/ ?>