<?php $__env->startSection('content'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="csrf-token2" content="<?php echo e(csrf_token()); ?>">
    <meta name="csrf-token3" content="<?php echo e(csrf_token()); ?>">

    <script src="https://d3js.org/d3.v7.min.js"></script>

    <style>
        .blinking-btn {
    position: relative;
    animation: blink-animation 1.5s infinite;
}

@keyframes blink-animation {
    0% {
        box-shadow: 0 0 10px rgba(255, 193, 7, 0.8), 0 0 20px rgba(255, 193, 7, 0.8), 0 0 30px rgba(255, 193, 7, 0.8);
    }

    50% {
        box-shadow: none;
    }

    100% {
        box-shadow: 0 0 10px rgba(255, 193, 7, 0.8), 0 0 20px rgba(255, 193, 7, 0.8), 0 0 30px rgba(255, 193, 7, 0.8);
    }
}
    </style>

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-lg-8 mb-4 order-0">
                <div class="card">
                    <div class="d-flex align-items-end row">
                        <div class="col-sm-7">
                            <div class="card-body">
                                <h5 class="card-title text-primary">Welcome to CCTV Monitoring Platforms 🎉</h5>
                                <p class="mb-4">
                                    
                                    To setup your platform please click this button
                                    </span>
                                </p>

                                <a href="<?php echo e(route('video-enrichment')); ?>"
                                    class="btn btn-sm btn-outline-primary blinking-btn">Camera & Region Management</a>


                            </div>
                        </div>
                        <div class="col-sm-5 text-center text-sm-left">
                            <div class="card-body pb-0 px-0 px-md-4">
                                <img src="<?php echo e(asset('assets/img/illustrations/man-with-laptop-light.png')); ?>" height="140"
                                    alt="View Badge User"
                                    data-app-dark-img="<?php echo e(asset('illustrations/man-with-laptop-dark.png')); ?>"
                                    data-app-light-img="<?php echo e(asset('illustrations/man-with-laptop-light.png')); ?>" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 order-1">
                <div class="row">
                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class="avatar flex-shrink-0">
                                        <img src="<?php echo e(asset('assets/img/icons/unicons/chart-success.png')); ?>"
                                            alt="chart success" class="rounded" />
                                    </div>
                                    <div class="dropdown">
                                        <button class="btn p-0" type="button" id="cardOpt3" data-bs-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            <i class="bx bx-dots-vertical-rounded"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="cardOpt3">
                                            <a class="dropdown-item" href="javascript:void(0);">View More</a>
                                        </div>
                                    </div>
                                </div>
                                <span class="fw-semibold d-block mb-1">Total Cameras</span>
                                <h3 class="card-title mb-2" id="total_cameras"><?php echo e($total_camera); ?></h3>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class="avatar flex-shrink-0">
                                        <img src="<?php echo e(asset('assets/img/icons/unicons/wallet-info.png')); ?>" alt="Credit Card"
                                            class="rounded" />
                                    </div>
                                    <div class="dropdown">
                                        <button class="btn p-0" type="button" id="cardOpt6" data-bs-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            <i class="bx bx-dots-vertical-rounded"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="cardOpt6">
                                            <a class="dropdown-item" href="javascript:void(0);">View More</a>
                                        </div>
                                    </div>
                                </div>
                                <span>Total Region</span>
                                <h3 class="card-title text-nowrap mb-1" id="active_cameras"><?php echo e($total_regions); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Total Revenue -->
            <div class="col-12 col-lg-8 order-2 order-md-3 order-lg-2 mb-4">
                <div class="row">
                    
                </div>
            </div>
            <!--/ Total Revenue -->
            <div class="col-12 col-md-8 col-lg-4 order-3 order-md-2">
                <div class="row">
                    
                    
                    <!-- </div>
                                                                                                                                    <div class="row"> -->
                    
                </div>
            </div>
        </div>
        <div class="row">
            <!-- Order Statistics -->
            <div class="col-md-12 col-lg-12 col-xl-12 order-0 mb-4">
                <div class="card h-100">
                    <div class="card-header d-flex align-items-center justify-content-between pb-0">
                        <div class="card-title mb-0">
                            <h5 class="m-0 me-2">Regions</h5>
                        </div>
                    </div>
                    <div class="card-body" style="margin-top: 20px;">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <table class="table table-striped table-bordered">
                                <tr>
                                    <th>Region Name</th>
                                    <th>Cameras In Region</th>
                                    <th>Created At</th>
                                </tr>
                                <?php if($regionsWithCameraCount): ?>
                                    <?php $__currentLoopData = $regionsWithCameraCount; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($list['region']); ?></td>
                                            
                                            <td><?php echo e($list['camera_count']); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::createFromTimestampMs($list['created_at'])->toDateTimeString()); ?></td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </table>

                        </div>
                        <div class="card-title mt-20">
                            <h6 class="m-0 me-2" style="text-align: end"><a href="<?php echo e(route('regions.all')); ?>">View All Regions</a></h6>
                        </div>

                    </div>
                </div>
            </div>
            <!--/ Transactions -->
        </div>
    </div>

    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\surveillance\resources\views/main.blade.php ENDPATH**/ ?>