<?php $__env->startSection('content'); ?>
    <style>
        select option {
            background-color: #007bff !important;
            color: white !important;
        }


        table {
            transform: scale(1);
            transform-origin: top left;
        }


        table.dataTable thead .sorting,
        table.dataTable thead .sorting_asc,
        table.dataTable thead .sorting_desc,
        table.dataTable thead .sorting_asc_disabled,
        table.dataTable thead .sorting_desc_disabled {
            background-image: url('https://cdn.datatables.net/1.10.24/images/sort_both.png');
            background-repeat: no-repeat;
            background-position: center right;
            cursor: pointer;
        }

        table.dataTable thead .sorting_asc {
            background-image: url('https://cdn.datatables.net/1.10.24/images/sort_asc.png');
        }

        table.dataTable thead .sorting_desc {
            background-image: url('https://cdn.datatables.net/1.10.24/images/sort_desc.png');
        }

        /* Remove hover-only display */
        table.dataTable thead>tr>th.sorting:before,
        table.dataTable thead>tr>th.sorting:after,
        table.dataTable thead>tr>th.sorting_asc:before,
        table.dataTable thead>tr>th.sorting_asc:after,
        table.dataTable thead>tr>th.sorting_desc:before,
        table.dataTable thead>tr>th.sorting_desc:after,
        table.dataTable thead>tr>th.sorting_asc_disabled:before,
        table.dataTable thead>tr>th.sorting_asc_disabled:after,
        table.dataTable thead>tr>th.sorting_desc_disabled:before,
        table.dataTable thead>tr>th.sorting_desc_disabled:after {
            opacity: 1 !important;
        }
    </style>

    <div class="container-xxl flex-grow-1 container-p-y">

        <?php if(isset($region)): ?>
            <div class="row" style="display: flow-root">
                <h5 class="card-title">Camera List</h5>
                <a href="<?php echo e(route('streamWithCamera.add', $region)); ?>"
                    style="width: fit-content;float: right;margin-bottom: 12px;margin-right:17px;"
                    class="btn btn-primary btn-xs">
                    <i class="menu-icon tf-icons bx bx-message-square-add"></i>New Camera
                </a>
            </div>
        <?php endif; ?>
        <div class="card" style="display: grid;height: 100%;">
            <div class="card-header">
                <h4 class="card-title">Camera Stream Monitoring and Analytics
                </h4>
            </div>


            <div class="row container d-flex justify-content-center">
                <div class="col-md-2 d-flex align-items-center">
                    <h3 class="">Filters:</h3>
                </div>
                <div class="col-md-3 d-flex align-items-center">
                    <input type="text" class="form-control" id="searchCamera" placeholder="Search Camera">
                    
                </div>
                <div class="col-md-3 d-flex align-items-center">
                    <input type="text" class="form-control" id="searchRegion" placeholder="Search Region">
                    
                </div>
                <div class="col-md-3 d-flex align-items-center">
                    <input type="text" class="form-control" id="searchUrl" placeholder="Search Stream URL">
                </div>
            </div>




            <div class="table-responsive p-2">
                <table class="display table " id="myDataTable" style="height: 100%;">
                    <thead>
                        <tr class="text-nowrap">
                            <th>#</th>
                            <th>Camera Name</th>
                            <th>Region Name</th>
                            <th>Streaming URl</th>
                            <th>Streaming Status</th>
                            <th>Virtual Wall</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($cameras): ?>
                            <?php $__currentLoopData = $cameras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th scope="row" style="vertical-align: middle;"><?php echo e(++$index); ?></th>
                                    <td><?php echo e($list['cameraname']); ?></td>
                                    <td><?php echo e($list['region']['region']); ?></td>
                                    <td>
                                        <span style="display: none">
                                            <?php echo e($list['stream_url']); ?>

                                        </span>

                                        <a href="javascript:void()" tabindex="0" class="" role="button"
                                            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-title="Stream URL"
                                            data-bs-content=" <?php echo e($list['stream_url']); ?>">View URL</a>
                                    </td>
                                    <td>
                                        <?php if($list['status'] == 1): ?>
                                            <span class="badge bg-success ">Active</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger badge-sm">Disconnected</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(isset($list['is_virtial_wall'])): ?>
                                            <?php if($list['is_virtial_wall'] == 1): ?>
                                                
                                                <label class="switch">
                                                    <input type="checkbox" checked disabled>
                                                    <span class="slider"></span>
                                                </label>
                                            <?php else: ?>
                                                
                                                <label class="switch">
                                                    <input type="checkbox" disabled>
                                                    <span class="slider"></span>
                                                </label>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            
                                            <label class="switch">
                                                <input type="checkbox" disabled>
                                                <span class="slider"></span>
                                            </label>
                                        <?php endif; ?>

                                    </td>
                                    <td>

                                        <?php $camera = $list['_id']; ?>
                                        <div class="dropdown">
                                            <a role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                                    fill="#ffffff" viewBox="0 0 256 256">
                                                    <path
                                                        d="M156,128a28,28,0,1,1-28-28A28,28,0,0,1,156,128ZM128,76a28,28,0,1,0-28-28A28,28,0,0,0,128,76Zm0,104a28,28,0,1,0,28,28A28,28,0,0,0,128,180Z">
                                                    </path>
                                                </svg>
                                            </a>
                                            <ul class="dropdown-menu">


                                                <li>
                                                    <a class="dropdown-item" href="<?php echo e(route('camera.monitor', $camera)); ?>">
                                                        <i class="menu-icon tf-icons bx bx-bell"></i>Monitor Stream</a>
                                                </li>


                                                <li>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('stream.frame.detected', $list['_id'])); ?>">
                                                        <i class="menu-icon tf-icons bx bx-bell"></i>Forensic Analysis</a>
                                                </li>

                                                

                                                <li class="dropdown-submenu">
                                                    <a class="dropdown-item d-flex align-items-center justify-content-between"
                                                        href="">
                                                        <span>Camera Stream Setup</span>
                                                        <i class="bi bi-caret-down-fill"
                                                            style="font-size: 15px; margin-left: 10px;"></i>
                                                    </a>

                                                    <ul class="" style="display: none">

                                                        <li>
                                                            <?php $camera = $list['_id']; ?>
                                                            <a class="dropdown-item"
                                                                onclick="event.preventDefault(); window.location.href = this.href;"
                                                                href="<?php echo e(route('camera.stream.setings', $camera)); ?>">
                                                                <i class="bi bi-dash-lg"
                                                                    style="margin-right: 10px;"></i>Camera Stream
                                                                Settings</a>
                                                        </li>


                                                        <li><a class="dropdown-item"
                                                                onclick="event.preventDefault(); window.location.href = this.href;"
                                                                href="<?php echo e(route('camera.find', $list['_id'])); ?>">
                                                                <i class="bi bi-dash-lg"
                                                                    style="margin-right: 10px;"></i>Edit Camera Stream
                                                                Source</a></li>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                onclick="event.preventDefault(); window.location.href = this.href;"
                                                                href="<?php echo e(route('alarm.settings.view', $list['_id'])); ?>">
                                                                <i class="bi bi-dash-lg"
                                                                    style="margin-right: 10px;"></i>Alarm/Notification
                                                                Settings</a>
                                                        </li>

                                                        <li>
                                                            <a class="dropdown-item" href="javacsript::void(0)"
                                                                onclick="deleteCamera('<?php echo e($list['_id']); ?>')">
                                                                <i class="bi bi-dash-lg" style="margin-right: 10px;"></i>
                                                                Delete</a>
                                                        </li>
                                                    </ul>
                                                </li>


                                            </ul>
                                        </div>









                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
            
            
        </div>


    </div>
    </div>
    </div>


    <script>
        function deleteCamera(id) {
            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "<?php echo e(url('delete/camera/')); ?>/" + id;
                }
            });
        }




        // ~ datatable ~

        $(document).ready(function() {
            $('#myDataTable').DataTable({
                searching: true,
                ordering: true,
                info: false,
                lengthChange: false, // This line hides the entries dropdown
                pageLength: 10, // Optional: Set default number of entries per page
                "order": [], // Disable initial sorting
                "columnDefs": [{
                        "orderable": true,
                        "targets": "_all"
                    }, // Make all columns orderable
                    {
                        "type": "string",
                        "targets": "_all"
                    } // Treat all column data as strings for sorting
                ]
            });

            $("#searchCamera").on('change', function() {
                $('#myDataTable').DataTable().column(1).search(
                    $(this).val(),
                    false, // regex
                    true // smart search
                ).draw();
            });

            $("#searchRegion").on('change', function() {
                $('#myDataTable').DataTable().column(2).search(
                    $(this).val(),
                    false, // regex
                    true // smart search
                ).draw();
            });

            $("#searchUrl").on('keyup', function() {
                $('#myDataTable').DataTable().column(3).search(
                    $(this).val(),
                    false, // regex
                    true // smart search
                ).draw();
            });
        });


        // ~~~ filters ~~~



        $(document).ready(function() {
            $("#searchCamera").on("keyup", function() {
                var value = $(this).val().toLowerCase();

                // Hide all rows first
                $("#myDataTable tbody tr").hide();

                // Show rows where 2nd column (Name) contains search text
                $("#myDataTable tbody tr").filter(function() {
                    return $(this).find("td:nth-child(2)").text().toLowerCase().indexOf(value) > -1;
                }).show();
            });
        });


        $(document).ready(function() {
            $("#searchRegion").on("keyup", function() {
                var value = $(this).val().toLowerCase();

                // Hide all rows first
                $("#myDataTable tbody tr").hide();

                // Show rows where 2nd column (Name) contains search text
                $("#myDataTable tbody tr").filter(function() {
                    return $(this).find("td:nth-child(3)").text().toLowerCase().indexOf(value) > -1;
                }).show();
            });
        });

        $(document).ready(function() {
            $("#searchUrl").on("keyup", function() {
                var value = $(this).val().toLowerCase();

                // Hide all rows first
                $("#myDataTable tbody tr").hide();

                // Show rows where 2nd column (Name) contains search text
                $("#myDataTable tbody tr").filter(function() {
                    return $(this).find("td:nth-child(4)").text().toLowerCase().indexOf(value) > -1;
                }).show();
            });
        });




        document.querySelectorAll('.dropdown-submenu').forEach(function(submenu) {
            // Toggle the submenu when clicking on the parent item
            submenu.addEventListener('click', function(e) {
                e.preventDefault(); // Prevent default link behavior
                e.stopPropagation(); // Prevent the click from bubbling up

                let submenuList = submenu.querySelector('ul');

                // Close all other open submenus
                document.querySelectorAll('.dropdown-submenu ul').forEach(function(menu) {
                    if (menu !== submenuList) {
                        menu.style.display = 'none';
                    }
                });

                // Toggle the clicked submenu
                if (submenuList.style.display === 'block') {
                    submenuList.style.display = 'none';
                } else {
                    submenuList.style.display = 'block';
                }
            });

            // Close submenu when clicking outside
            document.addEventListener('click', function(e) {
                if (!submenu.contains(e.target)) {
                    let submenuList = submenu.querySelector('ul');
                    submenuList.style.display = 'none';
                }
            });
        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\surveillance\resources\views/add/cameras_list.blade.php ENDPATH**/ ?>