<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <h5 class="card-header" style="color:black;"> Face Detection Details</h5>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Frame Info</th>
                            <th>Face</th>
                            <th>Photo Frame</th>
                            <th>Created At</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $faces_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>

                                    <?php if(isset($list['info'])): ?>
                                        <a style="color: white;" data-bs-toggle="modal"
                                            data-data="<?php echo e(json_encode($list['info'])); ?>" data-bs-target="#modalCenter2"
                                            class="btn btn-primary btn-xs">
                                            View Analytics
                                        </a>
                                    <?php endif; ?>


                                </td>
                                <td>
                                    <img src="data:image/png;base64, <?php echo e($list['detected_face_frame']); ?>"
                                        style="height:100px;" />
                                </td>
                                <td>
                                    <img src="data:image/png;base64, <?php echo e($list['draw_face_frame']); ?>"
                                        style="height:100px;" />
                                </td>
                                <td><?php echo e($list['created_at']); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
            
            
        </div>
        <div class="modal fade" id="modalCenter2" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered  modal-md" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCenterTitle">Face Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Age</th>
                                        <th>Gender</th>
                                        <th>Race</th>
                                    </tr>
                                </thead>
                                <tbody id="table-body">
                                    <!-- Data will be inserted here using JavaScript -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script>
        document.getElementById('modalCenter2').addEventListener('show.bs.modal', (e) => {
            var jsonData = e.relatedTarget.dataset.data;
            //alert("sd");
            console.log(JSON.parse(jsonData));
            populateTable(JSON.parse(jsonData));
        });


        function formatAliasesAndCategories(item) {
            const aliases = item.Aliases.map(alias => alias.age_list).join(', ');
            const categories = item.Categories.map(category => category.gender_list).join(', ');
            return `
                <strong>Aliases:</strong> ${aliases}<br>
                <strong>Categories:</strong> ${categories}
            `;
        }

        // Function to populate the table
        function populateTable(item) {
            const tableBody = document.getElementById('table-body');
            tableBody.innerHTML = '';

            const row = document.createElement('tr');
            row.innerHTML = `
                    <td>${item.age_list}</td>
                    <td>${item.gender_list}</td>
                    <td>${item.race_list}</td>
                `;
            tableBody.appendChild(row);
        }

        // Call the function to populate the table with your JSON data
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\surveillance\resources\views/forensic/view_face.blade.php ENDPATH**/ ?>